
#define SCPLX
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_caxpy(const int N, const void *alpha, const void *X,
                 const int incX, void *Y, const int incY)
{
   const float *x = X;
   float *y = Y;
   int incx = incX, incy = incY;

   if (incX < 0)
   {
      if (incY < 0) { incx = -incx; incy = -incY; }
      else x += -incX * ((N-1)<<1);
   }
   else if (incY < 0)
   {
      incy = -incy;
      incx = -incx;
      x += (N-1)*(incX<<1);
   }
   ATL_caxpy(N, alpha, x, incx, y, incy);
}
