------------------------------------------------------------------------------
--                                                                          --
--                            GNATELIM COMPONENTS                           --
--                                                                          --
--                       G N A T E L I M . E R R O R S                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- Gnatelim is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnatelim is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Gnatelim is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT).                                                         --
--                                                                          --
-- Gnatelim was originally developed by Alain Le Guennec                    --
--                                                                          --
-- Gnatelim  is  now  maintained  by  Ada  Core  Technologies  Inc          --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

package GNATELIM.Errors is

   pragma Elaborate_Body;

   Fatal_Error : exception;

   procedure Error   (Msg : Wide_String);
   pragma No_Return (Error);
   --  Issues an error Msg on Standard_Error,
   --  then raises Fatal_Error;

   procedure Warning (Msg : Wide_String);
   --  Issues a warning Msg on Standard_Error.

   function Number_Of_Errors   return Natural;
   --  Returns the total number of errors issued during the execution.
   pragma Inline (Number_Of_Errors);

   function Number_Of_Warnings return Natural;
   --  Returns the total number of warnings issued during the execution.
   pragma Inline (Number_Of_Warnings);

end GNATELIM.Errors;