
#define ALTPHON_OPT    'a'
#define CAPITALIZE_OPT 'c'
#define NUMERALS_OPT   'n'
#define SECURE_OPT     's'
#define HELP_OPT       'h'
int main(int argc, char **argv)
{
  int first_nonopt = 1; /* index of the first non-option in argv */
  int is_bad_opt = 0; /* true if unrecognized option */
  int cnt, len, wants_secure=0;
  char buf[20];
  int wants_alternate_phonics = 0; /* boolean from options */
  int wants_capitalize = 0; /* boolean from options */
  int wants_numerals = 0; /* boolean from options */
  int wants_help = 0; /* boolean from options */
  int getopt_result;
  int longindex = 0;

  getopt_result = 
    getopt_long
    (
      argc, 
      argv, 
      opt_string,
      longopts, 
      &longindex
    );

  while(getopt_result != EOF)
    {
      /* process opts here */
      
      switch(getopt_result)
	{
	case ALTPHON_OPT:
	  wants_alternate_phonics = 1;

	  disable_option("ash");

	  break;

	case CAPITALIZE_OPT:
	  wants_capitalize = 1;

	  disable_option("csh");

	  break;
	  
	case NUMERALS_OPT:
	  wants_numerals = 1;

	  disable_option("nsh");

	  break;

	case SECURE_OPT:
	  wants_secure = 1;
	  
	  disable_option("acnsh");
	  
	  break;
	  
	case HELP_OPT:
	  wants_help = 1;
	  
	  disable_option("acnsh");
	  
	  break;
	  
	case '?':
	default:
	  is_bad_opt = 1;
	  break;
	}
      
      if(is_bad_opt) 
	break;
      else
	getopt_result = 
	  getopt_long
	  (
	    argc, 
	    argv, 
	    opt_string, 
	    longopts, 
	    &longindex
	  );
    }
  
  if(wants_help)
    {
      usage(stdout, argv[0]);

      printf("You can use -a, -c or -n in any combination.\n");

      printf("You can't use these with -s or vise versa.\n");

      printf("\n");
      printf("\n");
      printf("OPTIONS\n");
      printf("\n");
      printf("  -a or --alt-phonics\n");
      printf("       use a slightly altered phonics table to generate\n");
      printf("       syllables.\n");
      printf("\n");
      printf("  -c or --capitalize\n");
      printf("       use (not so) random capitalizations in generated\n");
      printf("       passwords\n");
      printf("\n");
      printf("  -n or --numerals\n");
      printf("       use (not so) random placement of numerals in\n");
      printf("       generated passwords\n");
      printf("\n");
      printf("  -s or --secure\n");
      printf("       generate totally random, unmemorable, unpronouncable,\n");
      printf("       but secure and unguessable passwords\n");
      printf("\n");
      printf("  -h or --help\n");
      printf("       print this message and exit successfully\n");
      printf("\n");
      printf("\n");
      printf("ARGUMENTS\n");
      printf("\n");
      printf("  maxlength (required with -a, -c, -n or -s)\n");
      printf("       a number spec ifying the masimum length\n");
      printf("       of each generated password\n");
      printf("\n");
      printf("  count\n");
      printf("       the number of passwords generated. each will\n");
      printf("       be on its own line.\n");
      printf("\n");
      printf("SEE ALSO: man pwgen for details.\n");
      printf("\n");

      exit(0);
    }
  else if 
         ( 
	   (argc < first_nonopt + 1) 
	   || 
	   (argc > first_nonopt + 3) 
	   || (is_bad_opt) 
	 )
    {
      usage(stderr, argv[0]);
      
      return 1;
    }

  if ((len = atoi(argv[first_nonopt + 0])) < 4 || len > 16) 
    {
      fprintf
	(
	  stderr, 
	  "%s: invalid maxlength %s\n", 
	  argv[0], 
	  argv[first_nonopt + 0]
	);

      return 1;
    }

  if (argc == first_nonopt + 1)
    cnt = 1;                                      
  else if ((cnt = atoi(argv[first_nonopt + 1])) < 1) 
    {
      fprintf
	(
	  stderr, 
	  "%s: invalid count %s\n",  
	  argv[0], 
	  argv[first_nonopt + 1]
	);

      return 1;                                      
    }          
