#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <misc.h>
#include "xconf.h"
#include "section.h"

/* #Specification: strategy
	Each task of the X configurator produce a part of an Xconfig.
	(Some task have other side effect such has creating files and
	symlink). At the end, all parts are merged together in the following
	order.

		fonts
		keyboard
		mouse
		screen
		adaptor

	The merge goes like this. If a part supply a suboption which redefine
	one supplied by a previous part, then the new part has precedence.
	I don't expect this to happen often but I see a case. Adaptor are
	sometime more restrictive for the operationnal mode. For example
	some 8514 (all ?) board only support a fixed resolution (1024x768)
	beside the standard VGA. So even if the screen have all kind of
	resolution defined, the adaptor configuration will take precedence.

	The future will tell if this is true...
*/
	
struct XCONFIGS{
	XCONFIG adaptor;
	XCONFIG screen;
	XCONFIG mouse;
	XCONFIG keyboard;
	XCONFIG fonts;
};


static void xconf_other ()
{
	int done = 0;
	int choice = 0;
	while (!done){
		static char *menuopt[]={
			"See",		"current configuration",
			"Compare",	"Find the difference with",
			" ",		"the current /etc/XF86Config",
			" ",		"(don't change anything)",
		};
		xconf_menu ("The X configurator"
			,"Other options of xconf\n"
			 "      bla\n"
			 "      bla"
			,help_nil
			,menuopt,choice);
		if (choice == -1){
			done = 1;
		}else{
			switch (choice){
			case 0:
				// Show current configuration
				break;
			case 1:
				// Compare
				break;
			}
		}
	}
}

static char *xconf_formatmenu (
	XCONFIG &xcfg,
	const char *keyw)
{
	const char *val = xcfg.getcomment (keyw);
	char *curval = " -- Not set --";
	char bufval[80];
	if (val != NULL){
		sprintf (bufval," (%s)",val);
		curval = bufval;
	}
	char buf[200];
	sprintf (buf,"Configure the %s%s",keyw,curval);
	return strdup (buf);
}

int xconf_edit()
{
	/* #Specification: xconf / introduction
		xconf is an interactive configurator for XFree86. It
		reads and produces Xconfig files. xconf does not do any
		fancy mathematics. It is just a browser allowing the user
		to pick configuration option from a database of working
		setup, mostly extracted from modeDB.txt maintain by
		David Wexelblat [dwex@mtgzfs3.att.com].

		It allows you to pick configuration options related to the
		adaptor, the monitor and the mouse. For the mouse, it tries
		to be smarter probing around to identify the mouse since
		the users hardly know what is the clone mouse they have.
	*/
	/* Specification: menu / principal
		The user must select one of these choice

			configure the mouse
			configure the screen
			configure the adaptor
			quit
	*/
	XCONFIGS xcfgs;
	int done = 0;
	int choice = 0;
	while (!done){
		static char Adaptor[] = "Adaptor";
		static char Screen[] = "Screen";
		static char Mouse[] = "Mouse";
		static char Keyboard[]="Keyboard";
		static char Fonts[]="Fonts";
		static char Other[]="Other";
		static char Save[]="Save";
		static char Quit[]="Quit";
		static char *menuopt[]={
			Adaptor,	NULL,
			Screen,		NULL,
			Mouse,		NULL,
			Keyboard,	"Configure the keyboard",
			Fonts,		"Configure directories for fonts",
			"-------",	"---------------------",
			Other,		"other tasks ...",
			Save,		"Overwrite /etc/Xconfig",
			Quit,		"No save",
			NULL
		};
		menuopt[1] = xconf_formatmenu (xcfgs.adaptor,"Adaptor");
		menuopt[3] = xconf_formatmenu (xcfgs.screen,"Screen");
		menuopt[5] = xconf_formatmenu (xcfgs.mouse,"Mouse");
		xconf_menu ("The X configurator"
			,"This programs allows you to do the following things\n"
			 "      bla\n"
			 "      bla"
			,menuopt,choice);
		free (menuopt[1]);
		free (menuopt[3]);
		free (menuopt[5]);
		if (choice == -1){
			done = 1;
			break;
		}else{
			const char *key = menuopt[choice*2];
			if (key == Adaptor){
				xconf_adaptor (xcfgs.adaptor);
			}else if (key == Screen){
				xconf_screen (xcfgs.screen);
			}else if (key == Mouse){
				xconf_mouse (xcfgs.mouse);
			}else if (key == Keyboard){
				//xconf_keyboard (xcfgs.keyboard);
			}else if (key == Fonts){
				//xconf_fonts (xcfgs.fonts);
			}else if (key == Other){
				xconf_other();
			}else if (key == Save){
				// Save
				XCONFIG xcfg;
				xcfg.merge (&xcfgs.fonts);
				xcfg.merge (&xcfgs.keyboard);
				xcfg.merge (&xcfgs.mouse);
				xcfg.merge (&xcfgs.screen);
				xcfg.merge (&xcfgs.adaptor);
				xcfg.write ("/tmp/Xconfig");
				done = 1;
			}else if (key == Quit){
				done = 1;
			}
		}
	}
	xconf_end();
	return 0;
}

int xconf_main (int argc, char *argv[])
{
	return xconf_edit();
}

