#pragma implementation
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "internal.h"
#include "userconf.h"
#include <netconf.h>
#include "../paths.h"
#include "userconf.m"
#include <dialog.h>

static USERCONF_HELP_FILE help_intro ("intro");

static TRANS_NOTLOAD *section = P_MSG_U(T_MANAGEACCT,"User accounts");

PRIVILEGE p_managepop("managepop"
		,P_MSG_U(F_MANAGEPOP,"POP accounts manager")
		,section);
PRIVILEGE p_manageppp("manageppp"
		,P_MSG_U(F_MANAGEPPP,"PPP accounts manager")
		,section);
PRIVILEGE p_manageuucp("manageuucp"
		,P_MSG_U(F_MANAGEUUCP,"UUCP manager")
		,section);


/*
	Return the section title for user account co-admin privileges
*/
const char *userconf_getprivsection()
{
	return section->get();
}

void userconf_edit()
{
	/* #Specification: userconf / principal
		The userconf program allows you to edit/create/delete user
		accounts and groups.
	*/
	static const char *user_accounts = MSG_U(M_USER,"User accounts");
	static const char *groupe_def = MSG_U(M_GROUPDEF,"Group definitions");
	static const char *root_pass = MSG_U(M_ROOTPASS,"Change root password");
	static const char *std_ppp = MSG_U(M_PPP,"PPP accounts");
	static const char *std_slip = MSG_U(M_SLIP,"SLIP accounts via normal login");
	static const char *uucp_account = MSG_U(M_UUCP,"UUCP accounts");
	static const char *pop_accounts = MSG_U(M_POP,"POP accounts (mail only)");
	static const char *passwd_policies = MSG_U(M_POLICIES,"Password & account policies");
	static const char *usr_shells = MSG_U(M_USRSHELLS,"Available user shells");
	static const char *ppp_shells = MSG_U(M_PPPSHELLS,"Available PPP shells");
	static const char *slp_shells = MSG_U(M_SLPSHELLS,"Available SLIP shells");
	const char *menuopt1[]={
		"-",		MSG_U(M_NORMAL,"Normal"),
		"user:",	user_accounts,
		"users:",	groupe_def,
		"rootpasswd:",	root_pass,
		NULL
	};
	const char *menuopt2[]={
		"-",		MSG_U(T_SPCACCTS,"Special accounts"),
		"pppuser:",	std_ppp,
		"slipuser:",std_slip,
		"uucpuser:",uucp_account,
		"popuser:",	pop_accounts,
		NULL
	};
	const char *menuopt3[]={
		"-",		MSG_U(M_EALIAS,"Email aliases"),
		NULL
	};
	const char *menuopt4[]={
		"-",		MSG_U(T_POLICIES,"Policies"),
		"policies:",	passwd_policies,
		"",		usr_shells,
		"",		ppp_shells,
		"",		slp_shells,
		NULL
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt1);
	module_setmenu (dia,MENU_USER_STD);
	dia.new_menuitems (menuopt2);
	module_setmenu (dia,MENU_USER_SPC);
	{
		dia.new_menuitems (menuopt3);
		int nb = dia.getnb();
		module_setmenu (dia,MENU_USER_ALIAS);
		if (nb == dia.getnb()) dia.remove_del(nb-1);
	}
	dia.new_menuitems (menuopt4);
	module_setmenu (dia,MENU_USER_POLICIES);
	int choice=0;
	while (1){
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_UCONF,"User account configurator")
			,MSG_U(I_UCONFINTRO
			 ,"This package allows you to add/delete\n"
			 "and manage user accounts\n")
			,help_intro
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = dia.getmenustr (choice);
			module_domenu (MENU_USER_STD,key);
			module_domenu (MENU_USER_SPC,key);
			module_domenu (MENU_USER_POLICIES,key);
			module_domenu (MENU_USER_ALIAS,key);
			if (key == user_accounts){
				users_edit(NULL,NULL,USRACCT_EDITALL);
			}else if (key == pop_accounts){
				USER *like;
				if (special_init (POP_GROUP,like) != -1){
					users_edit(like,&p_managepop,0);
				}
				delete like;
			}else if (key == std_ppp){
				USER *like;
				if (special_init (PPP_GROUP,like) != -1){
					users_edit(like,&p_manageppp,USRACCT_EDITSHELL);
				}
				delete like;
			}else if (key == std_slip){
				USER *like;
				if (special_init (SLIP_GROUP,like) != -1){
					users_edit(like,&p_manageppp,USRACCT_EDITSHELL);
				}
				delete like;
			}else if (key == uucp_account){
				USER *like;
				if (special_init (UUCP_GROUP,like) != -1){
					users_edit(like,&p_manageuucp,0);
				}
				delete like;
			#if 0
				}else if (key == pap_ppp){
				}else if (key == chap_ppp){
			#endif
			}else if (key == groupe_def){
				groups_edit();
			}else if (key == passwd_policies){
				PASSWD_VALID vl;
				vl.edit();
			}else if (key == usr_shells){
				shells_edituser();
			}else if (key == ppp_shells){
				shells_editppp();
			}else if (key == slp_shells){
				shells_editslip();
			}else if (key == root_pass){
				if (simul_isdemo()){
					xconf_error (MSG_U(E_ROOTPASS
						,"You are not allowed to change root's password\n"
						 "in demo mode."));
				}else{
					USERS users;
					USER *root = users.getitem("root");
					if (root != NULL){
						SHADOW *shadow = users.getshadow(root);
						if (root->edithispass(shadow,true,"/") != -1){
							// If the user have succeeded changing root
							// password, he has temporarily the privilege
							// to update /etc/passwd
							perm_setbypass (1);
							users.writeif(NULL);
							perm_setbypass (0);
						}
					}
				}
			}
		}
	}
}

static void userconf_usagepasswd()
{
	xconf_error (MSG_U(E_PASSWDCMD
		,"Usage: passwd\n"
		 "             Change your own password\n"
		 "       passwd user_account\n"
		 "             Change interactivly this user account password\n"
		 "       passwd -h\n"
		 "       passwd --help\n"
		 "             Print this screen\n"
		 "       passwd -l user_account\n"
		 "             Lock the account\n"
		 "       passwd -P user_account\n"
		 "             Change the password from a pipe\n"
		 "             echo new_passwd | passwd -P user_account\n"
		 "       passwd -u user_account\n"
		 "             Unlock the account\n"
		));
	exit (-1);
}

/*
	Edit the password of the current user or one specific user
*/
int userconf_passwd (int argc, char *argv[])
{
	USERS users;
	int save_ok = -1;
	if (argc == 1){
		USER *usr = users.getfromuid(getuid());
		SHADOW *shadow = users.getshadow (usr);
		if (usr == NULL){
			xconf_error (
				MSG_U(E_NOUID,"Can't locate entry for uid %d\n"
				"in %s"),getuid(),ETC_PASSWD);
		}else{
			if ((isatty(0) && isatty(1) && getenv("TERM")!=NULL)
				|| getenv("DISPLAY")!=NULL){
				save_ok = usr->edithispass(shadow,true,"/");
			}else{
				save_ok = usr->edithispass_notty(shadow,"/");
			}
			if (save_ok != -1) perm_setbypass(1);// This let the write
												// succeed
		}
	}else if (argc >= 2){
		int i;
		bool pipemode = false;
		bool dolock = false;
		bool unlock = false;
		for (i=1; i<argc; i++){
			const char *arg = argv[i];
			if (strcmp(argv[i],"-h")==0 || strcmp(arg,"--help")==0){
				userconf_usagepasswd();
			}else if (strcmp(arg,"-l")==0){
				dolock = true;
			}else if (strcmp(arg,"-P")==0){
				pipemode = true;
			}else if (strcmp(arg,"-u")==0){
				unlock = true;
			}else if (strcmp(arg,"--")==0){
				break;
			}else if (arg[0] == '-'){
				userconf_usagepasswd();
			}else{
				break;
			}
		}
		if (i == argc - 1){
			const char *name = argv[argc-1];
			USER *usr = users.getitem(name);
			if (usr == NULL){
				xconf_error (MSG_U(E_UNKNOWNUSER,"Unknown user %s\n"),name);
			}else if (perm_rootaccess(MSG_U(P_CHGPASS
				,"change users password"))){
				SHADOW *shadow = users.getshadow (usr);
				if (dolock){
					usr->update_passwd (NULL,shadow,true,"/");
					save_ok = 0;
				}else if (unlock){
					usr->update_passwd (NULL,shadow,false,"/");
					save_ok = 0;
				}else if (pipemode){
					char buf[100];
					fgets (buf,sizeof(buf)-1,stdin);
					buf[99] = '\0';
					int len = strlen(buf);
					if (len > 0 && buf[len-1] == '\n') buf[len-1] = '\0';
					usr->update_passwd (buf,shadow,false,"/");
					save_ok = 0;
				}else{
					dialog_clear();
					save_ok = usr->editpass(shadow,true,true,"/");
				}
			}
		}else{
			userconf_usagepasswd();
		}
	}
	if (save_ok != -1) users.writeif(NULL);
	return 0;
}

static void usage()
{
	xconf_notice (MSG_U(I_USAGE,
		"userconf command line options\n"
		"\n"
		"    --adduser userid group username shell\n"
		"    --deluser userid\n"
		"    --addgroup group\n"
		"    --delgroup group\n"
		"    --help"));
}

const char *userconf_getusage()
{
	return MSG_R(I_USAGE);
}
int userconf_main (int argc, char *argv[])
{
	if (netconf_mainaccess ()){
		if (argc == 6 && strcmp(argv[1],"--adduser")==0){
			if (netconf_rootaccess()){
				users_add (argv[2],argv[3],argv[4],argv[5]);
			}
		}else if (argc == 3 && strcmp(argv[1],"--deluser")==0){
			if (netconf_rootaccess()){
				users_del (argv[2]);
			}
		}else if (argc == 3 && strcmp(argv[1],"--addgroup")==0){
			if (netconf_rootaccess()){
				groups_add (argv[2]);
			}
		}else if (argc == 3 && strcmp(argv[1],"--delgroup")==0){
			if (netconf_rootaccess()){
				groups_del (argv[2]);
			}
		}else if (argc == 2 && strcmp(argv[1],"--help")==0){
			usage();
		}else if (argc <= 1){
			userconf_edit();
		}else{
			usage();
		}
	}
	return 0;
}

void userconf_listspc ()
{
	html_sendintro ("text/html",-1,15,true);
	html_printf (
		"<HTML>\n"
		"<HEAD>\n"
		"<TITLE>%s</TITLE>\n"
		"</HEAD>\n"
		"<BODY>\n",MSG_U(T_SPCLINKS,"Special links"));



	html_printf ("<center><h1>%s</h1></center>\n",MSG_R(T_SPCLINKS));
	html_printf ("<hr>\n");
	html_printf ("<center><A HREF=/htmlmod:userpass:>%s</a></center><p>\n"
		,MSG_U(T_CHGPASS,"Change your password"));
	html_printf ("<center><A HREF=/htmlmod:userconf:>%s</a></center><p>\n"
		,MSG_U(T_EdITUSERS,"Administer user accounts"));

	module_sendmessage ("listspc",0,NULL);
	html_printf ("</body>\n");
	html_printf ("</html>\n");
	html_setdone();
}

