/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "managerpm.h"
#include "managerpm.m"
#include <module_apis/package_api.h>

MODULE_DEFINE_VERSION(managerpm);

PUBLIC MODULE_managerpm::MODULE_managerpm()
	: LINUXCONF_MODULE("managerpm")
{
	linuxconf_loadmsg ("managerpm",PACKAGE_REV);
	module_register_api (PACKAGE_API_KEY,PACKAGE_API_REV
		,managerpm_api_get,managerpm_api_release);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_managerpm::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MAIN_CONTROL){
		keymenu = MSG_U(M_managerpm,"Package management (RPM)");
		dia.new_menuitem ("managerpm","",keymenu);
	}
}

PUBLIC int MODULE_managerpm::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MAIN_CONTROL){
		if (key == keymenu){
			mngrpm_menu();
		}
	}
	return 0;
}


PUBLIC int MODULE_managerpm::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"managerpm")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module managerpm\n"
		 "\n"
		 "--root path\n"
		 "    Sets the root directory for package installation\n"
		 "\n"
		 "    Without argument, start the main menu\n")
		);
}

PUBLIC void MODULE_managerpm::usage(SSTRINGS &tb)
{
	tb.add (new SSTRING(MSG_R(T_USAGE)));
}

PUBLIC int MODULE_managerpm::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"managerpm")==0){
		ret = -1;
		if (netconf_mainaccess()){
			int i;
			for (i=1; i<argc; i++){
				const char *s = argv[i];
				if (strcmp(s,"--root")==0 && i+1 < argc){
					i++;
					mngrpm_setfsroot (argv[i]);
				}else{
					break;
				}
			}
			if (i == argc){
				mngrpm_menu();
			}else{
				// ### Add some option parsing for the module
				::usage();
			}
		}
	}
	return ret;
}


static MODULE_managerpm managerpm;

