#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "misc.h"
#include <userconf.h>
#include "misc.m"

static bool bypass = false;

/*
	Override the privilege checking associate with a file write
*/
void xconf_fopencfg_bypass (bool _bypass)
{
	bypass = _bypass;
}

/*
	Open a configuration file and print an error message if it can't be done.
	Check if root access is needed and prompt the user for the root password
	if the program is setuid.
*/
FILE *xconf_fopencfg (PRIVILEGE *priv, const char *fname, const char *mode)
{
	int wr_mode = strchr(mode,'w')!=NULL || strchr(mode,'a')!=NULL;;
	FILE *ret = NULL;
	if (bypass || !wr_mode || perm_access(priv,MSG_U(E_UPDATE,"Update %s"),fname)){
		ret = xconf_fopen (fname,mode);
	}else{
		errno = EPERM;
	}
	return ret;
}

