#include <string.h>
#include <limits.h>
#include <dirent.h>
#include "misc.h"

/*
	Get the list of files (anything in fact) in a directory
	Return the number of entry placed in lst.

	Return -1 if the directory can't be opened.
*/
int dir_getlist (const char *path, SSTRINGS &lst)
{
	int ret = -1;
	int start = lst.getnb();
	DIR *fin = opendir(path);
	if (fin != NULL){
		struct dirent *dire = NULL;
		while ((dire = readdir(fin))!=NULL){
			const char *d_name = dire->d_name;
			if (strcmp(d_name,".")!=0 && strcmp(d_name,"..")!=0){
				lst.add (new SSTRING(d_name));
			}
		}
		closedir(fin);
		ret = lst.getnb() - start;
	}
	return ret;
}

/*
	Get the list of files with a specific extension in a directory
	Return the number of entry placed in lst.

	The ending (extension) will be stripped from the filename.

	Return -1 if the directory can't be opened.
*/
int dir_getlist (
	const char *path,
	const char *ext,	// Ending of the file
						// Must include the . if you mean the extension
	SSTRINGS &lst)
{
	int start = lst.getnb();
	dir_getlist (path,lst);
	int lenext = strlen(ext);
	int nb = lst.getnb();
	for (int i=start; i<nb; i++){
		SSTRING *s = lst.getitem(i);
		char name[PATH_MAX];
		s->copy (name);
		char *pt = strstr(name,ext);
		if (pt != NULL && pt[lenext] == '\0'){
			*pt = '\0';
			s->setfrom (name);
		}else{
			lst.remove_del (s);
			i--;
			nb--;
		}
	}
	return lst.getnb() - start;
}

/*
	Get the list of files (anything in fact) in a directory beginning
	with the same prefix
*/
int dir_getlist_p (const char *fpath, SSTRINGS &lst)
{
	char bufpath[PATH_MAX];
	strcpy (bufpath,fpath);
	char *last = strrchr (bufpath,'/');
	char *dirpath = bufpath;
	char *prefix = "";
	if (last != NULL){
		*last = '\0';
		prefix = last+1;
	}else{
		prefix = bufpath;
		dirpath = ".";
	}
	SSTRINGS tmp;
	int nb = dir_getlist (dirpath,tmp);
	int ret = -1;
	if (nb != -1){
		ret = 0;
		int lenprefix = strlen(prefix);
		for (int i=0; i<nb; i++){
			const char *p = tmp.getitem(i)->get();
			if (strncmp(prefix,p,lenprefix)==0){
				char tmppath[PATH_MAX];
				sprintf (tmppath,"%s/%s",dirpath,p);
				lst.add (new SSTRING(tmppath));
				ret++;
			}
		}
	}
	return ret;
}

