#!/bin/bash
# chkdiffhelp.sh
# aurelio@conectiva.com.br
# Fri Oct 16 16:43:11 EDT 1998
# just a little thing to check the modified (newer) help files

DIROLD=../../linuxconf-$1/help.files/sources
DIRNEW=sources
HLPDIR=help.files

# just show the error msg on the screen
Error() { echo -e "\n$1\n"; exit }
DoIt() { ls *.sgml 2> /dev/null || echo "(none)" ; cd - }

# beginning of the barricade
[ ! $1 ] && Error "usage: chkdiffhelp.sh version-of-old-linuxconf"

[ "`pwd | rev | cut -c1-10 | rev`" = "$HLPDIR" ] || \
# `basename `pwd`` doesn't works...
Error "this script must be runned on the $HLPDIR directory"

[ -d $DIROLD ] || Error "the dir \"$DIROLD\" doesn't exist"
# end of the barricade

# find all the old sgmls
for ARQOLD in `find $DIROLD -name "*.sgml"`
do
  # exclude all the path of the old dir
  ARQNEW=$DIRNEW/`echo $ARQOLD | rev | cut -d/ -f1,2 | rev`
  # show the modified help files
  [ $ARQNEW -nt $ARQOLD ] && echo $ARQNEW | cut -d/ -f2-
done
