
#include <std.h>
#include <ops.h>

#include <parsers/strutl.h>

#include <func/apt.h>
#include <func/keys.h>
#include <func/pkgchecks.h>

#include <list/screens.h>
#include <list/colors.h>

#include <interface/coreui.h>
#include <interface/acquire.h>
#include <interface/formatting.h>
#include <interface/dialogs.h>

bool TextOp::CacheInit;
bool TextOp::BrokenFix;
unsigned TextOp::opRealCount;

void TextOp::PrepareOp(opType currentOp, string pkgstr)
{
	if (CacheInit == false)
	{
		ui_first_init();

		initialize_cache();
		CacheInit = true;

		BrokenFix = false;
		if (Cache->BrokenCount() != 0)
			BrokenFix = true;
	}

	bool Remove;

	if (currentOp == remove)
		Remove = true;

	else if (currentOp == purge)
	{
		Remove = true;
		_config->Set("APT::Console::Purge", "true");
	}
	else
		Remove = false;

	pkgCache::PkgIterator Pkg = Cache->FindPkg(pkgstr);

	if (Pkg.end() == true)
	{
		const char *P;
		for (P = pkgstr.c_str(); *P != 0; P++)
			if (*P == '.' || *P == '?' || *P == '*')
				break;

		if (*P == 0)
		{
			ui_dialog(0, "Not found", "\n Couldn't find package $2#%s$! in the package cache \n", pkgstr.c_str());
			return;
		}

		regex_t Pattern;

		if (regcomp(&Pattern, pkgstr.c_str(), REG_EXTENDED | REG_ICASE | REG_NOSUB) != 0)
			return (void) _error->Error("Regex compilation error");

		bool Hit = false;
		for (pkgCache::PkgIterator I = Cache->PkgBegin(); I.end() == false; I++)
		{
			if (regexec(&Pattern, I.Name(), 0, 0, 0) != 0)
				continue;

			Hit |= TryToInstall(I, *Cache, *Fix, Remove, BrokenFix, opRealCount);

			if (Hit == false)
			{
				erase();
				refresh();
			}
		}
		regfree(&Pattern);

		if (Hit == false)
			ui_dialog(0, "Match not found", "\n Couldn't match regexp '$2#%s$!' in the cache \n", pkgstr.c_str());
	}
	else
		TryToInstall(Pkg, *Cache, *Fix, Remove, BrokenFix, opRealCount);
}

void HelpDialog()
{
	KeyHandler::List * p = NULL;
	string s;

	Dialog Help;

	Help.geometry(25, 80, -1, -1);

	for (p = screen->kdriver->Liststart(); p->key != 0; p++)
	{
		if (p->handlefunc == NULL)
		{
			s = " ";
			s += p->KeyDesc;
			s += " ";
		}
		else
		{
			s = "  ";
			s += p->KeyName;
			for (int I = strlen(p->KeyName); I < 14; I++)
				s += " ";
			s += p->KeyDesc;
		}

		Help.addline(s, (void (*)(int)) p->handlefunc);
	}

	Help.title("capt key binding list");
	Help.execute();

	ui_redraw_current();
}

int search_string(const char *haystack, char *needle, unsigned long options, regex_t * rectx)
{
	if (options & SEARCH_REGEX)
	{
		return (int) !regexec(rectx, haystack, 0, NULL, 0);
	}
	else if (options & SEARCH_CASE)
	{
		int ret;
		char *hay = strdup(haystack);

		// needle must already be lower-case
		strlower(hay);
		ret = (int) strstr(hay, needle);

		free(hay);
		return ret;
	}
	else
	{
		return (int) strstr(haystack, needle);
	}
}
