/*
 * Copyright (c) 1999 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software and design ideas developed by the Java 
 *    Apache Project (http://java.apache.org/)."
 *
 * 4. The names "Cocoon", "Cocoon Servlet" and "Java Apache Project" must 
 *    not be used to endorse or promote products derived from this software 
 *    without prior written permission.
 *
 * 5. Products derived from this software may not be called "Cocoon"
 *    nor may "Cocoon" and "Java Apache Project" appear in their names without 
 *    prior written permission of the Java Apache Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software and design ideas developed by the Java 
 *    Apache Project (http://java.apache.org/)."
 *           
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *           
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Project. For more information
 * on the Java Apache Project please see <http://java.apache.org/>.
 */

package org.apache.cocoon.example;

import java.util.*;
import java.text.*;
import org.w3c.dom.*;
import javax.servlet.http.*;
import org.apache.cocoon.dcp.*;

public class DCPExample extends ServletDCPProcessor {
  private static int count = 0;

  public synchronized int getCount() {
    return ++count;
  } 

  public String getSystemDate(Dictionary parameters) {
    Date now = new Date();
    String formattedDate = now.toString();
    String format = (String) parameters.get("format");

    if (format != null) {
      try {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        formattedDate = dateFormat.format(now);
      } catch (Exception e) { } // Bad format, ignore and return default
    }

    return formattedDate;
  }

  public Element getRequestParameters() {
    Enumeration e = this.request.getParameterNames();

    if (!e.hasMoreElements()) { // No parameters given, remove node from document
      return null;
    }

    Element parameterList = createElement("parameters");

    int count;
    Element parameterValue;
    Element parameterElement;
    for (count = 0; e.hasMoreElements(); count++) {
      String name = (String) e.nextElement();
      String[] values = this.request.getParameterValues(name);

      parameterElement = createElement("parameter");
      parameterElement.setAttribute("name", name);

      for (int i = 0; i < values.length; i++) {
        parameterValue = createElement("parameter-value");
        parameterValue.appendChild(createTextNode(values[i]));

        parameterElement.appendChild(parameterValue);
      }

      parameterList.appendChild(parameterElement);
    }

    return parameterList;
  }
}