/*
 * jaZip for Linux  (c) 1996  Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <forms.h>
#include "pixmaps.h"
#include "jazip.h"
#include "help.h"
#include "about.h"

void		addto_help();

void help(FL_OBJECT *ob, long data)
{
	FD_jazip_help	*fd_jazip_help;
	FD_about			*fd_about;
	FD_jazip			*zpf = ob->u_vdata;
	FL_OBJECT		*obj;

	fl_set_object_lcol(zpf->file_menu, FL_INACTIVE);
	fl_set_object_lcol(zpf->tools_menu, FL_INACTIVE);
	fl_set_object_lcol(zpf->help_menu, FL_INACTIVE);
	fl_set_object_lcol(zpf->msg_browser, FL_INACTIVE);
	fl_deactivate_all_forms();

	switch (fl_get_menu(ob)){

	case HELP_ABOUT:
		fd_about = create_form_about();
		fl_show_form (fd_about->about,FL_PLACE_CENTER,FL_TRANSIENT,"About jaZip");
		while ((obj = fl_do_forms()) != fd_about->dismiss) ;
		fl_hide_form (fd_about->about);
		fl_free_form (fd_about->about);
		break;

	case HELP_HELP:
		fd_jazip_help = create_form_jazip_help();
		fd_jazip_help->help_browser->u_vdata = fd_jazip_help;
		fl_show_form (fd_jazip_help->jazip_help,FL_PLACE_CENTER,FL_TRANSIENT,"jaZip Help");
		fl_set_browser_fontsize (fd_jazip_help->help_browser, 12);
		fl_set_button (fd_jazip_help->help_overview, 1);
		show_topic (fd_jazip_help->help_browser, "overview.help");
		while( (obj = fl_do_forms()) != fd_jazip_help->dismiss){
			if (obj == fd_jazip_help->help_overview)
				show_topic (fd_jazip_help->help_browser, "overview.help");
			else if (obj == fd_jazip_help->help_menus)
				show_topic (fd_jazip_help->help_browser, "menus.help");
			else if (obj == fd_jazip_help->help_info)
				show_topic (fd_jazip_help->help_browser, "info.help");
			else if (obj == fd_jazip_help->help_mount)
				show_topic (fd_jazip_help->help_browser, "mount.help");
			else if (obj == fd_jazip_help->help_umount)
				show_topic (fd_jazip_help->help_browser, "unmount.help");
			else if (obj == fd_jazip_help->help_eject)
				show_topic (fd_jazip_help->help_browser, "eject.help");
			else if (obj == fd_jazip_help->help_ro)
				show_topic (fd_jazip_help->help_browser, "lock.help");
			else if (obj == fd_jazip_help->help_rw)
				show_topic (fd_jazip_help->help_browser, "unlock.help");
			else if (obj == fd_jazip_help->help_exit)
				show_topic (fd_jazip_help->help_browser, "exit.help");
		}
		fl_hide_form (fd_jazip_help->jazip_help);
		fl_free_form (fd_jazip_help->jazip_help);
		break;
	}

	fl_set_object_lcol(zpf->file_menu, FL_BLACK);
	fl_set_object_lcol(zpf->tools_menu, FL_BLACK);
	fl_set_object_lcol(zpf->help_menu, FL_BLACK);
	fl_set_object_lcol(zpf->msg_browser, FL_BLACK);
	fl_activate_all_forms();
	return;
}
