/* GMP3 - A front end for mpg123
 * Copyright (C) 1998 Brett Kosinski
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "gmp3.h"
#include "themerc.h"

int pressed = FALSE;

gint shape_pressed(GtkWidget *widget, GdkEventButton *event, 
                   ThemeWindow *window)
{
  WidgetLoc *p;
  gint xp, yp;
  GdkModifierType mask;  
  
  if (event->type == GDK_VISIBILITY_NOTIFY)
    return FALSE;
    
  gdk_window_get_position(window->main_window->window,
                          &(window->position.x), 
                          &(window->position.y));
    
  p = gtk_object_get_user_data(GTK_OBJECT(widget));
  gdk_window_get_pointer(root_win, &xp, &yp, &mask);
  
  p->x = window->position.x - xp;
  p->y = window->position.y - yp;
  
  gtk_grab_add(widget);
  
  gdk_pointer_grab(window->main_window->window, FALSE,
                   GDK_BUTTON_RELEASE_MASK |
                   GDK_BUTTON_MOTION_MASK,
                   NULL, NULL, 0); 
                     
  gdk_window_raise(window->main_window->window);
  pressed = TRUE;

#ifdef __DEBUG__
  g_print("Beginning window drag: \n");
  g_print("    Emitting Widget: %X\n", (int)(widget));
  g_print("    Window:          %X\n", (int)(window->main_window)); 
  g_print("    Fixed:           %X\n", (int)(window->fixed));
#endif
  
  return TRUE;
}                     

gint shape_released(GtkWidget *widget)
{
  if (! pressed) return FALSE;

  gdk_pointer_ungrab(0);
  gtk_grab_remove(widget);  
  pressed = FALSE;

#ifdef __DEBUG__
  g_print("Done window drag.\n");
#endif  

  return TRUE;
}

gint shape_motion(GtkWidget *widget, GdkEventMotion *event,
                  ThemeWindow *window)
{
  gint xp, yp;
  WidgetLoc *p;
  GdkModifierType mask;
  
  if (! pressed) return FALSE;
    
  p = gtk_object_get_user_data(GTK_OBJECT(widget));    
   
  gdk_window_get_pointer(root_win, &xp, &yp, &mask);
  window->position.x = xp + p->x;
  window->position.y = yp + p->y;
  
  if (window->position.x < 0) window->position.x = 0;
  if (window->position.y < 0) window->position.y = 0;
  
#ifdef __DEBUG__
  g_print("\nMoving Window\n");
  g_print("  New  X: %i\n", window->position.x);
  g_print("  New  y: %i\n", window->position.y);
#endif 
  
  gtk_widget_set_uposition(window->main_window, 
                           window->position.x,
                           window->position.y);
  gtk_widget_grab_focus(window->main_window);    

  return TRUE;
}
