/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

// Resource IDs for strings.

//	1000 - 1999: Message Templates
//		1000 - 1199:	Error messages
//		1200 - 1399:	Other messages
//	2000 - xxxx: Template Parts
//		2000 - 2199:	Misc parts
//		2200 - 2399:	Operations descriptions
//		2400 - 2599:	Error descriptions
//			2400 - 2499:	OS Errors (e.g., "the file was not found")
//			2500 - 2599:	User/app errors (e.g., "I don't understand that file")
//		2600 - 2799:	Recovery strings (e.g., "Reboot and try again")
//		2900 - 2964:	Exception descriptions (e.g., "bus error")
//		3000 - 4999:	Palm OS system function names
//		5000 - 6999:	Palm OS Library function names
//		7000 - xxxx:	Palm OS Error descriptions

// --------------------------------------------------------------------------------
//	Message Templates -- Error messages
// --------------------------------------------------------------------------------

#pragma mark Message Templates -- Error messages

#define kStr_OpError					1000
#define kStr_OpErrorRecover				1001

#define kStr_RegisterAccess				1100
#define kStr_LowMemAccess				1101
#define kStr_GlobalsAccess				1102
#define kStr_ScreenAccess				1103
#define kStr_MemMgrAccess				1104
#define kStr_UnlockedChunkAccess		1105
#define kStr_LowStackAccess				1106
#define kStr_UninitializedStackAccess	1107
#define kStr_FreeChunkAccess			1108
#define kStr_UninitializedChunkAccess	1109
#define kStr_StorageHeapAccess			1110
#define kStr_UnimplementedTrap			1111
#define kStr_A5Access					1112
#define kStr_NULLMemAccess				1113
#define kStr_SANEUsage					1114
#define kStr_WroteToROM					1115
#define kStr_InvalidPC					1116

#define kStr_SysError					1121
#define kStr_UnhandledException			1122
#define kStr_CorruptedHeap				1123
#define kStr_StackOverflowWarning		1124
#define kStr_StackOverflowFatal			1125
#define kStr_LongMemSemaphore			1126
#define kStr_SizelessFormObject			1127
#define kStr_OffscreenFormObject		1128
#define kStr_BadChecksum				1129
#define kStr_DebugBreak					1130

// --------------------------------------------------------------------------------
//	Message Templates -- Other messages
// --------------------------------------------------------------------------------

#pragma mark Message Templates -- Other messages

#define kStr_AppAndVers				1200
#define kStr_XofYFiles				1201
#define kStr_GremlinNumber			1202
#define kStr_XofYEvents				1203
#define kStr_XEvents				1204
#define kStr_ElapsedTime			1205
#define kStr_GremlinStarted			1206
#define kStr_GremlinEnded			1207
#define kStr_SaveScreenAs			1208
#define kStr_EntireDevice			1209
#define kStr_ErrDisplayMessage		1210
#define kStr_UnknownFatalError		1211
#define kStr_EmulatorOff			1212
#define kStr_SaveBeforeClosing		1213
#define kStr_SaveBeforeQuitting		1214
#define kStr_LogFileSize			1215


// --------------------------------------------------------------------------------
//	Template Parts -- Misc parts
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Misc parts

#define kStr_AppName				2000
#define kStr_Untitled				2001
#define kStr_DefaultROMName			2002
#define kStr_ProfileResults			2003
#define kStr_Autoload				2004
#define kStr_Autorun				2005
#define kStr_AutorunAndQuit			2006

#define kStr_ReadFrom				2010
#define kStr_WrittenTo				2011

#define kStr_CurrentAppUC			2020
#define kStr_CurrentAppLC			2021
#define kStr_UnknownVersion			2022

#define kStr_OK						2030
#define kStr_Cancel					2031
#define kStr_Yes					2032
#define kStr_No						2033
#define kStr_Continue				2034
#define kStr_Debug					2035
#define kStr_Reset					2036

#define kStr_Browse					2040

#define kStr_ProfPartial			2050
#define kStr_ProfFunctions			2051
#define kStr_ProfInterrupts			2052
#define kStr_ProfOverflow			2053
#define kStr_ProfInterruptX			2054
#define kStr_ProfTrapNameAddress	2055
#define kStr_ProfROMNameAddress		2056
#define kStr_ProfDebugNameAddress	2057
#define kStr_ProfUnknownName		2058

#define kStr_UnknownTrapNumber		2060
#define kStr_UnknownErrorCode		2061

#define kStr_NoPort					2070

#define kStr_ChunkNotInHeap			2080
#define kStr_ChunkTooLarge			2081
#define kStr_InvalidFlags			2082
#define kStr_HOffsetNotInMPT		2083
#define kStr_HOffsetNotBackPointing	2084
#define kStr_InvalidLockCount		2085

#define kStr_UnmappedAddress		2090
#define kStr_NotInCodeSegment		2091
#define kStr_OddAddress				2092


// --------------------------------------------------------------------------------
//	Template Parts -- Operations descriptions
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Operations descriptions

#define kStr_GenericOperation		2200

#define kStr_CmdAbout				2210

#define kStr_CmdNew					2220
#define kStr_CmdOpen				2221
#define kStr_CmdClose				2222
#define kStr_CmdSave				2223
#define kStr_CmdSaveScreen			2224
#define kStr_CmdInstall				2225
#define kStr_CmdInstallMany			2226
#define kStr_CmdExportDatabase		2227
#define kStr_CmdHotSync				2228
#define kStr_CmdReset				2229
#define kStr_CmdTransferROM			2230
#define kStr_CmdQuit				2231

#define kStr_CmdPreferences			2240
#define kStr_CmdLoggingOptions		2241
#define kStr_CmdDebugOptions		2242
#define kStr_CmdSkins				2243
#define kStr_CmdBreakpoints			2244

#define kStr_CmdGremlinNew			2250
#define kStr_CmdGremlinStep			2251
#define kStr_CmdGremlinResume		2252
#define kStr_CmdGremlinStop			2253

#define kStr_CmdProfileStart		2260
#define kStr_CmdProfileStop			2261
#define kStr_CmdProfileDump			2262

#define kStr_ResizeWindow			2270
#define kStr_EnterKey				2271
#define kStr_EnterPen				2272
#define kStr_PressButton			2273
#define kStr_OpenFiles				2274
#define kStr_LoadPreferences		2275
#define kStr_OpenTheSerialPort		2276


// --------------------------------------------------------------------------------
//	Template Parts -- Error descriptions -- OS Errors
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Error descriptions -- OS Errors

#define kStr_GenericError			2400
#define kStr_UserCancel				2401	// userCanceledErr
#define kStr_TimeoutError			2402	// kernelTimeoutErr

#define kStr_DirectoryFull			2410	// dirFulErr
#define kStr_DiskFull				2411	// dskFulErr
#define kStr_DiskMissing			2412	// nsvErr, volOffLinErr, volGoneErr
#define kStr_IOError				2413	// ioErr
#define kStr_BadFileName			2414	// bdNamErr
#define kStr_TooManyFilesOpen		2415	// tmfoErr
#define kStr_FileNotFound			2416	// fnfErr
#define kStr_DiskWriteProtected		2417	// wPrErr
#define kStr_FileLocked				2418	// fLckdErr, permErr
#define kStr_DiskLocked				2419	// vLckdErr
#define kStr_FileBusy				2420	// fBsyErr
#define kStr_DuplicateFileName		2421	// dupFNErr

#define kStr_MemFull				2430	// memFullErr, kError_OutOfMemory

#define kStr_SerialPortBusy			2440

#define kStr_GenericPalmError		2480
#define kStr_DmErrDatabaseOpen		2481	// dmErrDatabaseOpen
#define kStr_MemErrNotEnoughSpace	2482	// memErrNotEnoughSpace


// --------------------------------------------------------------------------------
//	Template Parts -- Error descriptions -- User/app errors
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Error descriptions -- User/app errors

#define kStr_OnlySameType			2500
#define kStr_OnlyOnePSF				2501
#define kStr_OnlyOneROM				2502
#define kStr_UnknownType			2503

#define kStr_OldFormat				2510
#define kStr_WrongROMForType		2511	// kError_WrongROMForType

#define kStr_BadROM					2520	// kError_BadROM
#define kStr_UnsupportedROM			2521	// kError_UnsupportedROM


// --------------------------------------------------------------------------------
//	Template Parts -- Recovery strings
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Recovery strings

#define kStr_DeleteSomeFiles		2610
#define kStr_UnlockTheDisk			2611
#define kStr_UnlockTheFile			2612

#define kStr_NeedMoreRAM			2620

#define kStr_TransferAROM			2630
#define kStr_DownloadAROM			2631


// --------------------------------------------------------------------------------
//	Template Parts -- Exception descriptions
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Exception descriptions

#define kStr_ExceptionBase			2900


// --------------------------------------------------------------------------------
//	Template Parts -- Palm OS function names
// --------------------------------------------------------------------------------

#pragma mark Template Parts -- Palm OS function names

#define kStr_SysTrapBase			3000

#define kStr_LibTrapBase			5000
#define kStr_HTALLibTrapBase		kStr_LibTrapBase + 100
#define kStr_INetLibTrapBase		kStr_LibTrapBase + 200
#define kStr_IrLibTrapBase			kStr_LibTrapBase + 300
#define kStr_NetLibTrapBase			kStr_LibTrapBase + 400
#define kStr_NPILibTrapBase			kStr_LibTrapBase + 500
#define kStr_RailLibTrapBase		kStr_LibTrapBase + 600
#define kStr_SecLibTrapBase			kStr_LibTrapBase + 700
#define kStr_SerLibTrapBase			kStr_LibTrapBase + 800
#define kStr_WebLibTrapBase			kStr_LibTrapBase + 900

// --------------------------------------------------------------------------------
//	Template Parts -- Error descriptions
// --------------------------------------------------------------------------------
#pragma mark Template Parts -- Palm OS Error descriptions

#define kStr_PalmOSErrorBase		7000

// Copied from SystemMgr.h -- needed for string ID assignments

/************************************************************
 * Error Classes for each manager
 *************************************************************/
#define	errNone						0x0000	// No error

#define	memErrorClass				0x0100	// Memory Manager
#define	dmErrorClass				0x0200	// Data Manager
#define	serErrorClass				0x0300	// Serial Manager
#define	slkErrorClass				0x0400	// Serial Link Manager
#define	sysErrorClass				0x0500	// System Manager
#define	fplErrorClass				0x0600	// Floating Point Library
#define	flpErrorClass				0x0680	// New Floating Point Library
#define	evtErrorClass				0x0700  	// System Event Manager
#define	sndErrorClass				0x0800  	// Sound Manager
#define	almErrorClass				0x0900  	// Alarm Manager
#define	timErrorClass				0x0A00  	// Time Manager
#define	penErrorClass				0x0B00  	// Pen Manager
#define	ftrErrorClass				0x0C00  	// Feature Manager
#define	cmpErrorClass				0x0D00  	// Connection Manager (HotSync)
#define	dlkErrorClass				0x0E00	// Desktop Link Manager
#define	padErrorClass				0x0F00	// PAD Manager
#define	grfErrorClass				0x1000	// Graffiti Manager
#define	mdmErrorClass				0x1100	// Modem Manager
#define	netErrorClass				0x1200	// Net Library
#define	htalErrorClass				0x1300	// HTAL Library
#define	inetErrorClass				0x1400	// INet Library
#define	exgErrorClass				0x1500	// Exg Manager
#define	fileErrorClass				0x1600	// File Stream Manager
#define	rfutErrorClass				0x1700	// RFUT Library
#define	txtErrorClass				0x1800	// Text Manager
#define	tsmErrorClass				0x1900	// Text Services Library
#define	webErrorClass				0x1A00	// Web Library
#define	secErrorClass				0x1B00	// Security Library
#define	emuErrorClass				0x1C00	// Emulator Control Manager
#define	flshErrorClass				0x1D00	// Flash Manager
#define	pwrErrorClass				0x1E00	// Power Manager
#define	cncErrorClass				0x1F00	// Connection Manager (Serial Communication)
#define	actvErrorClass				0x2000	// Activation application

#define  errInfoClass				0x7F00	// special class shows information w/o error code
#define	appErrorClass				0x8000	// Application-defined errors

