/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _STRING_CONVERSIONS_H_
#define _STRING_CONVERSIONS_H_

#include "EmulatorTypes.h"

// ----------------------------------------------------------------------
//	Our preferences routines need to convert our preference data to and
//	from string format (the format in which the data is stored on disk).
//	Following are a bunch of overloaded routines for converting strings
//	into all the data types we use for preferences.
// ----------------------------------------------------------------------

bool FromString (const string& s, bool& value);
bool FromString (const string& s, char& value);
bool FromString (const string& s, signed char& value);
bool FromString (const string& s, unsigned char& value);
bool FromString (const string& s, signed short& value);
bool FromString (const string& s, unsigned short& value);
bool FromString (const string& s, signed int& value);
bool FromString (const string& s, unsigned int& value);
bool FromString (const string& s, signed long& value);
bool FromString (const string& s, unsigned long& value);
bool FromString (const string& s, string& value);
bool FromString (const string& s, char* value);
bool FromString (const string& s, CloseActionType& value);
bool FromString (const string& s, DeviceType& value);
bool FromString (const string& s, FileReference& value);

// ----------------------------------------------------------------------
//	Our preferences routines need to convert our preference data to and
//	from string format (the format in which the data is stored on disk).
//	Following are a bunch of overloaded routines for converting data
//	(in all the types we use for preferences) into strings.
// ----------------------------------------------------------------------

string ToString (bool value);
string ToString (char value);
string ToString (signed char value);
string ToString (unsigned char value);
string ToString (signed short value);
string ToString (unsigned short value);
string ToString (signed int value);
string ToString (unsigned int value);
string ToString (signed long value);
string ToString (unsigned long value);
string ToString (const string& value);
string ToString (const char* value);
string ToString (CloseActionType value);
string ToString (DeviceType value);
string ToString (const FileReference& value);

#endif	/* _STRING_CONVERSIONS_H_ */
