/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _STARTUP_H_
#define _STARTUP_H_

#include "EmulatorTypes.h"		// FileRefList, Configuration, HordeInfo

class Startup
{
	public:
		static Bool				DetermineStartupActions	(int argc, char** argv);

		static void				GetAutoLoads			(FileRefList&);
		static string			GetAutoRunApp			(void);

		// Getters...

		static Bool				AskWhatToDo				(void);
		static Bool				CreateSession			(Configuration&);
		static Bool				OpenSession				(FileReference&);
		static Bool				NewHorde				(HordeInfo*);
		static Bool				CloseSession			(FileReference&);
		static Bool				QuitOnExit				(void);
		static Bool				Quit					(void);

		// Setters...

		static void				Clear					(void);
		static void				ScheduleAskWhatToDo		(void);
		static void				ScheduleCreateSession	(const Configuration&);
		static void				ScheduleOpenSession		(const FileReference&);
		static void				ScheduleNewHorde		(const HordeInfo&, const StringList&);
		static void				ScheduleCloseSession	(const FileReference&);
		static void				ScheduleQuitOnExit		(void);
		static void				ScheduleQuit			(void);
};

#endif	/* _STARTUP_H_ */
