/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _PLATFORM_NETLIB_H_
#define _PLATFORM_NETLIB_H_


class Platform_NetLib
{
	public:
		static Bool				Redirecting (void);

		static Err				Open (Word libRefNum, WordPtr netIFErrsP);
		static Err				OpenConfig (Word libRefNum, Word configIndex, DWord openFlags, WordPtr netIFErrsP);
		static Err				Close (Word libRefNum, Word immediate);
		static Err				Sleep (Word libRefNum);
		static Err				Wake (Word libRefNum);
		static Err				FinishCloseWait(Word libRefNum);
		static Err				OpenIfCloseWait(Word libRefNum);
		static Err				OpenCount (Word refNum, WordPtr countP);
		static Err				HandlePowerOff (Word refNum, EventPtr eventP);
		static Err				ConnectionRefresh(Word refNum, Boolean refresh, 
									BooleanPtr allInterfacesUpP, WordPtr netIFErrP);
		static NetSocketRef		SocketOpen(Word libRefNum, NetSocketAddrEnum domain, 
									NetSocketTypeEnum type, SWord protocol, SDWord timeout, 
									Err* errP);
		static SWord			SocketClose(Word libRefNum, NetSocketRef socket, SDWord timeout, 
									Err* errP);
		static SWord			SocketOptionSet(Word libRefNum, NetSocketRef socket,
									NetSocketOptLevelEnum level, NetSocketOptEnum option, 
									VoidPtr optValueP, Word optValueLen,
									SDWord timeout, Err* errP);
		static SWord			SocketOptionGet(Word libRefNum, NetSocketRef socket,
									NetSocketOptLevelEnum level, NetSocketOptEnum option,
									VoidPtr optValueP, WordPtr optValueLenP,
									SDWord timeout, Err* errP);
		static SWord			SocketBind(Word libRefNum, NetSocketRef socket,
									NetSocketAddrType* sockAddrP, SWord addrLen, SDWord timeout, 
									Err* errP);
		static SWord			SocketConnect(Word libRefNum, NetSocketRef socket,
									NetSocketAddrType* sockAddrP, SWord addrLen, SDWord timeout, 
									Err* errP);
		static SWord			SocketListen(Word libRefNum, NetSocketRef socket,
									Word queueLen, SDWord timeout, Err* errP);
		static SWord			SocketAccept(Word libRefNum, NetSocketRef socket,
									NetSocketAddrType* sockAddrP, SWord* addrLenP, SDWord timeout,
									Err* errP);
		static SWord			SocketShutdown(Word libRefNum, NetSocketRef socket, 
									SWord /*NetSocketDirEnum*/ direction, SDWord timeout, Err* errP);
		static SWord			SocketAddr(Word libRefNum, NetSocketRef socketRef,
									NetSocketAddrType* locAddrP, SWord* locAddrLenP, 
									NetSocketAddrType* remAddrP, SWord* remAddrLenP, 
									SDWord timeout, Err* errP);
		static SWord			SendPB(Word libRefNum, NetSocketRef socket,
									NetIOParamType* pbP, Word flags, SDWord timeout, Err* errP);
		static SWord			Send(Word libRefNum, NetSocketRef socket,
									const VoidPtr bufP, Word bufLen, Word flags,
									VoidPtr toAddrP, Word toLen, SDWord timeout, Err* errP);
		static SWord			ReceivePB(Word libRefNum, NetSocketRef socket,
									NetIOParamType* pbP, Word flags, SDWord timeout, Err* errP);
		static SWord			Receive(Word libRefNum, NetSocketRef socket,
									VoidPtr bufP, Word bufLen, Word flags, 
									VoidPtr fromAddrP, WordPtr fromLenP, SDWord timeout, Err* errP);
		static SWord			DmReceive(Word libRefNum, NetSocketRef socket,
									VoidPtr recordP, DWord recordOffset, Word rcvLen, Word flags, 
									VoidPtr fromAddrP, WordPtr fromLenP, SDWord timeout, Err* errP);
		static NetHostInfoPtr	GetHostByName(Word libRefNum, CharPtr nameP, 
									NetHostInfoBufPtr bufP, Long timeout, Err* errP);
		static NetHostInfoPtr	GetHostByAddr(Word libRefNum, BytePtr addrP, Word len, Word type,
									NetHostInfoBufPtr bufP, Long timeout, Err* errP);
		static NetServInfoPtr	GetServByName(Word libRefNum, CharPtr servNameP, 
									CharPtr protoNameP, NetServInfoBufPtr bufP, 
									Long timeout, Err* errP);
		static SWord			GetMailExchangeByName(Word libRefNum, CharPtr mailNameP, 
									Word maxEntries, 
									Char hostNames[][netDNSMaxDomainName+1], Word priorities[], 
									Long timeout, Err* errP);
		static SWord			Select(Word libRefNum, Word width, NetFDSetType* readFDs, 
									NetFDSetType* writeFDs, NetFDSetType* exceptFDs,
									Long timeout, Err* errP);
};

#endif	// _PLATFORM_NETLIB_H_
