/*******************************************************************
 * 							 Pilot Software
 *
 *		 Copyright(c) 1994, Palm Computing Inc., All Rights Reserved  
 *
 *-------------------------------------------------------------------
 * FileName:
 *		KeyPrv.h
 *
 * Description:
 *		Private Include file for Key manager
 *
 * History:
 *   	9/13/95 		Created by Ron Marianetti
 *    2/04/98 srj	Added modifications to keymgr globals (keyState and 
 *						associated variables are now words) 
 *						added private routine prototypes for keyboard scanning
 *						on Razor.
 *		3/31/98 		Added support for the Antenna key on Jerry
 *		8/30/98 scl Reordered KeyGlobalsType to match 3.1, for better
 *						alignment, and to more closely match older OS revs
 *
 *******************************************************************/

#ifdef	NON_PORTABLE
#ifndef __KEYPRV_H
#define __KEYPRV_H


/********************************************************************
 * Key Manager Constants
 ********************************************************************/
#define	keyMinUpTicks					(sysTicksPerSecond/20)	// Min# of ticks key must be up to recognize it

#define	keyMinBacklightTicks			(sysTicksPerSecond)		// Min# of ticks key must be held down to
																				// turn on backlight

#define	keyMinAntennaTicks			(sysTicksPerSecond/2)	// Min# of ticks key antenna must be up to
																				// generate antenna event

// The following is obsolete in EZ, as port D isn't a key map anymore.

#define	keyPortDMaskPower			0x01	// Power key
#define	keyPortDMaskPageUp		0x02	// Page-up
#define	keyPortDMaskPageDown		0x04	// Page-down
#define	keyPortDMaskHard1			0x08	// App #1
#define	keyPortDMaskHard2			0x10	// App #2
#define	keyPortDMaskHard3			0x20	// App #3
#define	keyPortDMaskHard4			0x40	// App #4
#define	keyPortDMaskAntenna		0x80	// The bit in port D for the antenna. 

#define	keyPortDMaskStd			0x7F	// Which bits in port D we use for standard keys
#define	keyBitMaskStd				0x7F  // These map 1 to 1 to the keyBitXXX
													//  equates returned by KeyCurrentState defined
													//  in KeyMgr.h

#define	keyBitAllKeys					0x01FF	// Which bits in keyState are 
															// actually used for keys

/********************************************************************
 * Key Manager Globals
 ********************************************************************/
typedef struct KeyGlobalsType {
	ULong		lastKeyTicks;					// GHwrCurTicks last time we enqueued a key event;
													//  cleared as soon as key is released.

	Byte		keyStateV30;					// OBSOLETE: current state of hardware keys
													//  (kept for SW compatibility with old apps)
	Byte		keyStateMaskV30;				// OBSOLETE: which keys generate an event


	Byte		keyUpCount;						// # of consecutive times we've detected
													// no keys down - used for debouncing
	Byte		initDelay;						// key repeat init delay in ticks


	Byte		period;							// key repeat period in ticks
	Boolean	queueAhead;						// if true, enqueue auto-repeat keys even if 
													// queue is not empty. (Moved in 2.0 and 3.1)

	DWord		turnOnTicks;					// Tickcount for key that turned device on.  Used
													// for detecting when we should turn on backlight.
	
	// These fields are for sensing double-taps
	ULong		doubleTapTicks;				// GHwrCurTicks last time we enqueued
													//  a key event - never cleared. 
	Word		doubleTapDelay;				// double-tap timeout in ticks

	Byte		doubleTapStateV30;			// OBSOLETE: state of hardware keys last time (for compat.)

	Byte		unused;							// filler for alignment; feel free to use
	Byte		usedPortDBits;					// 3.1: set to keyBitMaskStd if no antenna key
													//      set to (keyBitMaskStd | keyBitMaskAntenna) if 
													//      antenna key is available. (new in 3.2)
	Byte		antKeyPendCount;				// used as a counter and flag to signal pending antenna up event

	// PalmOS 3.1: These fields are new, wider fields that can handle more than eight keys.
	// The byte fields (labeled "V30" above) are shadowed for compatibility w/old apps.
	// However, apps should *NOT* be reading these fields directly!!
	DWord		keyState;						// 3.1: current state of hardware keys
													//      returned by KeyCurrentState
	DWord		keyStateMask;					// 3.1: which keys generate an event
	DWord		doubleTapState;				// 3.1: state of hardware keys last time
	
	} KeyGlobalsType;
	
typedef KeyGlobalsType*	KeyGlobalsPtr;





/********************************************************************
 * Key manager Routines
 ********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

// Called early on during boot-up to get status of hard reset
//  and debugger key options. Returns DWord with bits set for each
//  key down.
DWord		KeyBootKeys(void);
				

// Initializes the Key Manager and allocates it's globals
Err		KeyInit(void)
				SYS_TRAP(sysTrapKeyInit);


// Called as a result of a key-down interrupt or periodically by
//  by timer task while key is down. Returns # of ticks before
//  it should be called again by timer task.
ULong		KeyHandleInterrupt(Boolean periodic, DWord status)
				SYS_TRAP(sysTrapKeyHandleInterrupt);
				
			
// Called by SysEvtMgr when it gets a pen event in order to
//  reset the key manager's double-tap detection.
Err		KeyResetDoubleTap(void)
				SYS_TRAP(sysTrapKeyResetDoubleTap);


// Called before system goes to sleep
Err		KeySleep(Boolean untilReset, Boolean emergency)
				SYS_TRAP(sysTrapKeySleep);


// Called when the system wakes up
Err		KeyWake(void)
				SYS_TRAP(sysTrapKeyWake);


/********************************************************************
 * Private Routines
 ********************************************************************/

// 2 uS delay routine
void	prvDelay2us(void);

// Enable/Disable keyboard interrupts
void	prvEnableKeyInterrupts(Boolean);
void	prvDisableKeyInterrupts(void);

// Scan Keyboard
DWord	prvKeyScan(void);
DWord PrvScanKeyStatus(void);

#ifdef __cplusplus
}
#endif

	
#endif	//__KEYPRV_H
#endif 	// NON_PORTABLE
