########################################################################
#
#	File:			EmFunctions.pm
#
#	Purpose:		Perl wrappers for Palm OS functions
#
#	Description:	This file contains Perl equivalents of Palm OS
#					functions like DmNumDatabases, FrmGetActiveForm,
#					etc.  Currently, the functions here are generated
#					by hand, and so only a small subset of Palm OS
#					functions are wrapped.  In the future, this file
#					(or files) may be automatically generated by
#					a script that converts the SDK headers.
#
#					In general, functions follow the calling
#					conventions in the SDK headers.  However, there
#					are exceptions.  See the comments before each
#					subroutine for details.
#
########################################################################

package EmFunctions;

use Exporter ();
@ISA = qw(Exporter);

@EXPORT = qw(
	CtlGetLabel

	DmNumDatabases DmFindDatabase DmDatabaseInfo

	EvtEnqueuePenPoint

	FrmGetActiveForm FrmGetLabel FrmGetNumberOfObjects FrmGetObjectBounds
	FrmGetObjectId FrmGetObjectPtr FrmGetObjectType FrmGetTitle

	HostGetHostVersion
	HostGremlinNew
	HostSessionCreate HostSessionOpen HostSessionClose HostSessionQuit
	HostSignalWait HostSignalResume
	HostMemRead HostMemWrite

	MemChunkFree MemPtrFree MemPtrNew

	SysUIAppSwitch

	frmFieldObj frmControlObj frmListObj frmTableObj frmBitmapObj frmLineObj
	frmFrameObj frmRectangleObj frmLabelObj frmTitleObj frmPopupObj
	frmGraffitiStateObj frmGadgetObj frmScrollBarObj
);

use EmRPC;
use EmSysTraps;

$slkSocket = EmRPC::slkSocketPoserRPC;
#$slkSocket = EmRPC::slkSocketDebugger;
$slkPktType = EmRPC::slkPktTypeSystem;

use constant frmFieldObj			=> 0;
use constant frmControlObj			=> 1;
use constant frmListObj				=> 2;
use constant frmTableObj			=> 3;
use constant frmBitmapObj			=> 4;
use constant frmLineObj				=> 5;
use constant frmFrameObj			=> 6;
use constant frmRectangleObj		=> 7;
use constant frmLabelObj			=> 8;
use constant frmTitleObj			=> 9;
use constant frmPopupObj			=> 10;
use constant frmGraffitiStateObj	=> 11;
use constant frmGadgetObj			=> 12;
use constant frmScrollBarObj		=> 13;

use constant hostSelectorGetHostVersion			=> 0x0100;
use constant hostSelectorGetHostID				=> 0x0101;
use constant hostSelectorGetHostPlatform		=> 0x0102;
use constant hostSelectorIsSelectorImplemented	=> 0x0103;
use constant hostSelectorGestalt				=> 0x0104;
use constant hostSelectorIsCallingTrap			=> 0x0105;

use constant hostSelectorGremlinIsRunning		=> 0x0400;
use constant hostSelectorGremlinNumber			=> 0x0401;
use constant hostSelectorGremlinCounter			=> 0x0402;
use constant hostSelectorGremlinLimit			=> 0x0403;
use constant hostSelectorGremlinNew				=> 0x0404;

use constant hostSelectorSessionCreate			=> 0x0800;
use constant hostSelectorSessionOpen			=> 0x0801;
use constant hostSelectorSessionClose			=> 0x0802;
use constant hostSelectorSessionQuit			=> 0x0803;
use constant hostSelectorSignalSend				=> 0x0804;
use constant hostSelectorSignalWait				=> 0x0805;
use constant hostSelectorSignalResume			=> 0x0806;
use constant hostSelectorMemRead				=> 0x0807;
use constant hostSelectorMemWrite				=> 0x0808;


########################################################################
#
#	FUNCTION:		CtlGetLabel
#
#	DESCRIPTION:	Return a string pointer to the control's text label.
#
#	PARAMETERS:		Memory address on the remote device of the control
#					object.  Usually the result of something like
#					FrmGetObjectPtr on a control object.
#
#	RETURNED:		A list containing the memory address on the remote
#					device of the label, and the label string itself.
#
########################################################################

sub CtlGetLabel
{
	# const Char* CtlGetLabel (const ControlType * ctlP)

	my ($return, $format) = ("string", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapCtlGetLabel, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmNumDatabases
#
#	DESCRIPTION:	Returns the number of databases on a card
#
#	PARAMETERS:		card number
#
#	RETURNS:		Number of databases found
#
########################################################################

sub DmNumDatabases
{
	# UInt DmNumDatabases (UInt cardNo)

	my ($return, $format) = ("int16", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapDmNumDatabases, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmDatabaseInfo
#
#	DESCRIPTION:	Retrieves database information
#
#	PARAMETERS:		Card number, database LocalID
#
#	RETURNS:		Result code from function, as well as the components
#					of a hash.  To get the result, assign the result
#					of this function to ($err, %results).  You can
#					then extract individual values from %results using
#					hash operators and the following keys: name
#					attributes, version, crDate, modDate, bckUpDate,
#					modNum, appInfoID, sortInfoID, type, and creator.
#					Example: $name = $results{name}.
#
########################################################################

sub DmDatabaseInfo
{
	# Err DmDatabaseInfo (UInt cardNo, LocalID	dbID, const CharPtr nameP,
	#				UIntPtr attributesP, UIntPtr versionP, ULongPtr crDateP,
	#				ULongPtr modDateP, ULongPtr bckUpDateP,
	#				ULongPtr modNumP, LocalID* appInfoIDP,
	#				LocalID* sortInfoIDP, ULongPtr typeP,
	#				ULongPtr creatorP)

	my ($cardNo, $dbID) = @_;

	my ($format) = "int16 LocalID string32 int16* int16* int32* int32* " .
					"int32* int32* LocalID* LocalID* int32* int32*";
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapDmDatabaseInfo, $format,
						$cardNo, $dbID, "", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

	($D0,	name		=> $params[2],
			attributes	=> $params[3],
			version		=> $params[4],
			crDate		=> $params[5],
			modDate		=> $params[6],
			bckUpDate	=> $params[7],
			modNum		=> $params[8],
			appInfoID	=> $params[9],
			sortInfoID	=> $params[10],
			type		=> $params[11],
			creator		=> $params[12]);
}


########################################################################
#
#	FUNCTION:		DmFindDatabase
#
#	DESCRIPTION:	Searches for a database by name
#
#	PARAMETERS:		card number, database name
#
#	RETURNS:		LocalID of database header
#
########################################################################

sub DmFindDatabase
{
	# LocalID DmFindDatabase (UInt cardNo, const CharPtr nameP)

	my ($return, $format) = ("LocalID", "int16 string");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapDmFindDatabase, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		EvtEnqueuePenPoint
#
#	DESCRIPTION:	Called by the digitizer interrupt routine to enqueue
#					a pen coordinate into the pen queue.
#
#	PARAMETERS:		x and y coordinates, subtracted from 256.
#					Example: EvtEnqueuePoint (256 - 100, 256 - 80)
#					Pass in (-1, -1) to enqueue a Pen Up.
#
#	RETURNS:		size of queue in bytes
#
########################################################################

sub EvtEnqueuePenPoint
{
	# Err EvtEnqueuePenPoint (PointType* ptP)

	my ($return, $format) = ("Err", "point");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapEvtEnqueuePenPoint, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetActiveForm
#
#	DESCRIPTION:	This routine returns the currently active form.
#
#	PARAMETERS:		nothing
#
#	RETURNED:		Memory address on the remote device of the form.
#
########################################################################

sub FrmGetActiveForm
{
	# FormPtr FrmGetActiveForm (void)

	my ($return, $format) = ("rptr", "");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetActiveForm, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetLabel
#
#	DESCRIPTION:	This routine return the text of the specified label object
#					in the specified form.
#
#	PARAMETERS:		formP		- memory block that contains the form.
#					labelID		- id of the label object.
#
#	RETURNED:		A list containing the memory address on the remote
#					device of the label, and the label string itself.
#
########################################################################

sub FrmGetLabel
{
	# CharPtr FrmGetLabel (const FormPtr frm, const Word lableID)

	my ($return, $format) = ("string", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetLabel, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetNumberOfObjects
#
#	DESCRIPTION:	This routine returns the number of objects in a form.
#
#	PARAMETERS:		formP		memory block that contains the form.
#
#	RETURNED:		number of object in the form specified
#
########################################################################

sub FrmGetNumberOfObjects
{
	# Word FrmGetNumberOfObjects (const FormPtr frm)

	my ($return, $format) = ("int16", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetNumberOfObjects, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectBounds
#
#	DESCRIPTION:	This routine returns the bounds of the specified form object
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	index of the object
#
#	RETURNS:		The components of a hash.  To get the result, assign
#					the result of this function to %results.  You can
#					then extract individual values from %results using
#					hash operators and the following keys: top, left
#					bottom, right, width, height.
#					Example: $top = $results{top}.
#
########################################################################

sub FrmGetObjectBounds
{
	# void FrmGetObjectBounds (const FormPtr frm, const Word pObjIndex, const RectanglePtr r)

	my ($form, $obj_index) = @_;

	my ($return, $format) = ("", "rptr int16 rect");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetObjectBounds, $format,
											$form, $obj_index, {});

	my ($foo) = $params[2];
	%$foo;
}


########################################################################
#
#	FUNCTION:		FrmGetObjectId
#
#	DESCRIPTION:	This routine returns the id of the object specified.  
#					An id is a value specified by the application developer 
#					that uniquely identifies an object.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	item number of the object
#
#	RETURNED:		Object ID.
#
########################################################################

sub FrmGetObjectId
{
	# UInt16 FrmGetObjectId (const FormType * formP, UInt16 objIndex)

	my ($return, $format) = ("int16", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetObjectId, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectPtr
#
#	DESCRIPTION:	This routine returns a pointer to the data structure of an 
#					object in a form.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	item number of the object
#
#	RETURNED:		Memory address on the remote device of the object.
#					The contents of the object depend on the object type.
#
########################################################################

sub FrmGetObjectPtr
{
	# VoidPtr FrmGetObjectPtr (const FormPtr frm, const Word objIndex)

	my ($return, $format) = ("rptr", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetObjectPtr, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectType
#
#	DESCRIPTION:	This routine returns the type of an object.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	item number of the object
#
#	RETURNED:		FormObjectType of the item specified
#
########################################################################

sub FrmGetObjectType
{
	# FormObjectKind FrmGetObjectType (const FormPtr frm, const Word objIndex)

	my ($return, $format) = ("int16", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetObjectType, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}

########################################################################
#
#	FUNCTION:		FrmGetTitle
#
#	DESCRIPTION:	This routine returns a pointer to the title string of a 
#					form.
#
#	PARAMETERS:		formP	  - memory block that contains the form.
#
#	RETURNED:		A list containing the memory address on the remote
#					device of the title, and the title string itself.
#
########################################################################

sub FrmGetTitle
{
	# const Char * FrmGetTitle (const FormType * formP)

	my ($return, $format) = ("string", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapFrmGetTitle, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostGetHostVersion
#
#	DESCRIPTION:	Get the version of the host (Palm OS Emulator).
#
#	PARAMETERS:		None
#
#	RETURNS:		Version number of Poser in Palm OS version format.
#
########################################################################

sub HostGetHostVersion
{
	# long HostGetHostVersion(void)

	my ($return, $format) = ("int32", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorGetHostVersion, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostGremlinNew
#
#	DESCRIPTION:	Start a new Gremlin Horde.
#
#	PARAMETERS:		Starting Gremlin number.
#					Ending Gremlin number.
#					Frequency (in terms of Gremlin events) at which
#						states are automatically saved.
#					Switching depth (number of events generated before
#						switching to a different Gremlin).
#					Max depth (maximum number of events generated
#						for each Gremlin).
#					List of application names on which to run Gremlins.
#
#	RETURNS:		Error code.
#
########################################################################

sub HostGremlinNew
{
	# HostErr HostGremlinNew(const HostGremlinInfo*)

	($start, $stop, $save_freq, $switch_depth, $max_depth, @apps) = @_;

	my ($app_string) = join (",", @apps);

	my ($struct) = pack("NNNNN", $start, $stop, $save_freq, $switch_depth, $max_depth) . $app_string;

	my ($return, $format) = ("HostErr", "int16 block");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorGremlinNew, $struct);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostSessionCreate
#
#	DESCRIPTION:	Create a new session.
#
#	PARAMETERS:		Name of device to emulate.  Choices are: "Pilot",
#						"PalmPilot", "Palm III", "Palm IIIx",
#						"Palm V", "Palm VII".
#					RAM size (in K) to emulate.
#					Path to ROM to use.
#
#	RETURNS:		Error code.
#
########################################################################

sub HostSessionCreate
{
	# HostErr HostSessionCreate(const char* device, long ramSize, const char* romPath)

	my ($return, $format) = ("HostErr", "int16 string int32 string");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorSessionCreate, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostSessionOpen
#
#	DESCRIPTION:	Open a previously create session file.
#
#	PARAMETERS:		Path to session file to open.
#
#	RETURNS:		Error code.
#
########################################################################

sub HostSessionOpen
{
	# HostErr HostSessionOpen(const char* psfFileName)

	my ($return, $format) = ("HostErr", "int16 string");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorSessionOpen, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostSessionClose
#
#	DESCRIPTION:	Close the current session, optionally saving it.
#
#	PARAMETERS:		Name of session file to create. Can be null.
#
#	RETURNS:		Error code.
#
########################################################################

sub HostSessionClose
{
	# HostErr HostSessionClose(const char* saveFileName)

	my ($return, $format) = ("HostErr", "int16 string");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorSessionClose, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostSessionQuit
#
#	DESCRIPTION:	Ask Palm OS Emulator to quit.
#
#	PARAMETERS:		None
#
#	RETURNS:		Error code.
#
########################################################################

sub HostSessionQuit
{
	# HostErr HostSessionQuit(void)

	my ($return, $format) = ("HostErr", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorSessionQuit, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		HostSignalWait
#
#	DESCRIPTION:	Wait for a signal from the Palm OS Emulator.
#
#	PARAMETERS:		timeout (in milliseconds)
#
#	RETURNS:		List containing the error code and the numeric
#					signal value returned from the Emulator.
#
########################################################################

sub HostSignalWait
{
	# HostErr HostSignalWait(long timeout, HostSignal* signalNumber)

	my ($return, $format) = ("HostErr", "int16 int32 int32*");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorSignalWait, $_[0], 0);

	($D0, $params[2]);	# 0 = selector, 1 = timeout, 2 = signal number
}


########################################################################
#
#	FUNCTION:		HostSignalResume
#
#	DESCRIPTION:	Tell the Emulator to resume after it has sent us
#					a signal.
#
#	PARAMETERS:		None
#
#	RETURNS:		Error code.
#
########################################################################

sub HostSignalResume
{
	# HostErr HostSignalResume(void)

	my ($return, $format) = ("HostErr", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapHostControl, $format,
						hostSelectorSignalResume, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemChunkFree
#
#	DESCRIPTION:	Disposes of a chunk
#
#	PARAMETERS:		Pointer to chunk
#
#	RETURNS:		0 if no error
#
########################################################################

sub MemChunkFree
{
	my ($return, $format) = ("Err", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapMemChunkFree, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemPtrFree
#
#	DESCRIPTION:	Disposes of a chunk
#
#	PARAMETERS:		Pointer to chunk
#
#	RETURNS:		0 if no error
#
########################################################################

sub MemPtrFree
{
	MemChunkFree (@_);
}


########################################################################
#
#	FUNCTION:		MemPtrNew
#
#	DESCRIPTION:	Allocates a non-movable chunk in the dynamic heap
#
#	PARAMETERS:		requested size of chunk
#
#	RETURNS:		Ptr to chunk, or 0 if error
#
########################################################################

sub MemPtrNew
{
	my ($return, $format) = ("rptr", "int32");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapMemPtrNew, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}

########################################################################
#
#	FUNCTION:		SysUIAppSwitch
#
#	DESCRIPTION:	Tries to make the current UI application quit and
#					then launches the given UI application by card
#					number and database ID.
#
#	PARAMETERS:		cardNo, dbID
#
#	RETURNS:		errNone if no err
#
########################################################################

sub SysUIAppSwitch
{
	# Err SysUIAppSwitch(UInt16 cardNo, LocalID dbID, UInt16 cmd, MemPtr cmdPBP)

	my ($return, $format) = ("Err", "int16 LocalID int16 rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (sysTrapSysUIAppSwitch, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}

1;
