/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.*;
import org.w3c.dom.Node;

/**
 * A class that represents the XSL True() function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class TrueFunctionCall extends FunctionCall {
    
    /**
     * Creates a new TrueFunctionCall
    **/
    public TrueFunctionCall() {
        super(Names.TRUE_FN);
    } //-- TrueFunctionCall
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a BooleanResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {        
        return BooleanResult.TRUE_RESULT;
    } //-- evaluate
    
} //-- TrueFunctionCall