/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;

import com.kvisco.xsl.*;

import java.util.Hashtable;
import com.kvisco.util.Tokenizer;
import com.kvisco.util.List;

import org.w3c.dom.*;

/**
 * This class represents an Id() function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class IdFunctionCall extends FunctionCall {
    
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    /**
     * Creates an IdFunctionCall
    **/
    public IdFunctionCall() {
        super(Names.ID_FN);
    } //-- IdExpr
    
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps)
        throws InvalidExprException 
    {
        NodeSet nodeSet = new NodeSet();
        
        Hashtable idRefs = null;
        if (ps != null) idRefs = ps.getIDReferences();
        Node tmpNode;
        List params = super.getParameterList();
        if (params.size() == 1) {
            Expr expr = (Expr)params.get(0);
            ExprResult exprResult = expr.evaluate(context,ps);
            Tokenizer st = new Tokenizer(exprResult.toString());
            while (st.hasMoreTokens()) {
                tmpNode = (Element)idRefs.get(st.nextToken());
                if (tmpNode != null) nodeSet.add(tmpNode);
            }
        }
        return nodeSet;
    } //-- evaluate
    
} //-- IdFunctionCall