/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */
package com.kvisco.xsl.functions;

import org.w3c.dom.Node;

import com.kvisco.xsl.*;
import com.kvisco.util.List;
import com.kvisco.xml.XMLUtil;

/**
 * A class for representing function call
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class ExtensionFunctionCall extends FunctionCall {
        
    public static final String FUNCTION_NOT_DEFINED =
        "The following function has not been defined: ";
        
    public ExtensionFunctionCall(String name) {
        super(name);
    } //-- ExtensionFunctionCall
    
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/    
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException 
    {
        
        String qname = getFunctionName();
        String ns    = XMLUtil.getNameSpace(qname);
        String name  = XMLUtil.getLocalPart(qname);
        
        if (ns.length() == 0) ns = null;
        
        ScriptHandler sh = ps.getScriptHandler(name, ns);
        
        if (sh == null)
            return new StringResult(FUNCTION_NOT_DEFINED+qname);
            
        List params = getParameterList();
        Object[] args = new Object[params.size()];
        
        //-- evaluate arguments
        for (int i = 0; i < params.size(); i++) {
            Expr expr = (Expr)params.get(i);
            ExprResult exprResult = expr.evaluate(context, ps);
            args[i] = exprResult.toJavaObject();
        }
        
        Object obj = sh.call(name, args, ns);
        return new StringResult(obj.toString());
    } //-- evaluate
    
    /**
     * Returns the namespace that this function call is in
    **/
    public String getNameSpace() {
        return XMLUtil.getNameSpace(getFunctionName());
    } //-- getNameSpace
    
} //-- ExtensionFunctionCall