/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The software is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the software. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */
package com.kvisco.xsl;

import java.io.PrintWriter;
import java.util.Hashtable;
import com.kvisco.util.List;
import org.w3c.dom.*;

/**
 * Represents an XSLIf Object (xsl:if)
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class XSLIf extends XSLObject 
    implements Conditional {
                
    private BooleanExpr booleanExpr = null;
    
    /**
     * Creates a new XSLIf object
    **/
    public XSLIf(XSLStylesheet parentStylesheet) {
        super(parentStylesheet,XSLObject.IF);
    } //-- XSLIf
    
    /**
     * Returns the BooleanExpr of this XSL conditional
     * @return the BooleanExpr of this XSL conditional
    **/
    public BooleanExpr getBooleanExpr() throws InvalidExprException {
        
        if (booleanExpr == null) {
            
            String exprStr = getAttribute(Names.TEST_ATTR);
            if ((exprStr == null) || (exprStr.length() == 0))
                booleanExpr = new BooleanExpr();
            else {
                //-- change this later to #createBooleanExpr
                booleanExpr 
                    = new BooleanExpr(ExpressionParser.createExpr(exprStr));
            }
        }
        
        return booleanExpr;
    } //--getBooleanExpr
        
        
    public BooleanResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException 
    {
        // call #getBooleanExpr to make sure we have parsed
        // the test attribute
        if (getBooleanExpr() == null)
            return BooleanResult.FALSE_RESULT;
        else
            return (BooleanResult) this.booleanExpr.evaluate(context, ps);
    } //-- evaluate
    
    /**
     * Sets the attribute with the given name to the given value.
     * @param name the name of the attribute to set
     * @param value the value to set the attribute to
     * @throws XSLException if this XSLObject does not allow attributes
     * with the given name, or if the attribute is read only
    **/
    public void setAttribute(String name, String value) 
        throws XSLException
    {
        if (Names.TEST_ATTR.equals(name)) booleanExpr = null;
        super.setAttribute(name,  value);
    } //-- setAttribute
    
    public void setBooleanExpr(BooleanExpr booleanExpr) {
        
        try {
            if (booleanExpr == null)
                super.setAttribute(Names.TEST_ATTR,"");
            else 
                super.setAttribute(Names.TEST_ATTR, booleanExpr.toString());
        }
        catch(XSLException xslException) {};
        
        this.booleanExpr = booleanExpr;
    } //-- setBooleanExpr
    
    
} //-- XSLIf