/*
 * (C) Copyright Keith Visco 1998,1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */
package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * This class represents an Empty XSLObject in the style tree. 
 * It prevents child XSLObjects from being added to the list
 * of actions.
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class EmptyXSLObject extends XSLObject {
    
    //private String[] requiredAttributes = {};
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    public EmptyXSLObject(XSLStylesheet parentStylesheet, short type) {
        super(parentStylesheet,type);
        super.setAllowActions(false);
    } //-- EmptyXSLElement
    
    //protected void setRequiredAttributes(String[] attNames) {
    //    this.requiredAttributes = attNames;
    //} //-- setRequiredAttributes

} //-- EmptyXSLObject
