/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.util.QuickStack;
import com.kvisco.xml.XMLUtil;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class XMLNamesFunctionCall
extends FunctionCall {
    public static final short LOCAL_PART = 1;
    public static final short NAME = 2;
    public static final short NAMESPACE = 3;
    private short fType = (short)2;

    public XMLNamesFunctionCall() {
        super("name");
    }

    public XMLNamesFunctionCall(short s) {
        super(XMLNamesFunctionCall.getFunctionName(s));
        this.fType = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        QuickStack quickStack = processorState.getNodeSetStack();
        NodeSet nodeSet = null;
        if (quickStack.empty()) {
            nodeSet = new NodeSet();
            nodeSet.add(node);
        } else {
            nodeSet = (NodeSet)quickStack.peek();
        }
        String string = null;
        List list = super.getParameterList();
        if (list.size() == 1) {
            NodeSet nodeSet2;
            Expr expr = (Expr)list.get(0);
            ExprResult exprResult = expr.evaluate(node, processorState);
            if (exprResult.getResultType() == 2 && (nodeSet2 = (NodeSet)exprResult).size() > 0) {
                string = nodeSet2.get(0).getNodeName();
            }
        } else {
            string = node.getNodeName();
        }
        switch (this.fType) {
            case 1: {
                return new StringResult(XMLUtil.getLocalPart(string));
            }
            case 3: {
                return new StringResult(XMLUtil.getNameSpace(string));
            }
        }
        return new StringResult(string);
    }

    private static String getFunctionName(short s) {
        switch (s) {
            case 1: {
                return "local-part";
            }
            case 3: {
                return "namespace";
            }
        }
        return "name";
    }
}

