/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.functions.FunctionCall;
import java.text.DecimalFormat;
import org.w3c.dom.Node;

public class FormatNumber
extends FunctionCall {
    public FormatNumber() {
        super("format-number");
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        int n = list.size();
        if (n < 2 || n > 3) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        ExprResult exprResult = ((Expr)list.get(0)).evaluate(node, processorState);
        double d = exprResult.numberValue();
        if (Double.isNaN(d)) {
            return new StringResult("NaN");
        }
        if (Double.isInfinite(d)) {
            return new StringResult("Infinite");
        }
        exprResult = ((Expr)list.get(1)).evaluate(node, processorState);
        String string = StringExpr.toStringResult(exprResult).toString();
        String string2 = null;
        if (n == 3) {
            exprResult = ((Expr)list.get(2)).evaluate(node, processorState);
            string2 = StringExpr.toStringResult(exprResult).toString();
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return new StringResult(decimalFormat.format(d));
    }
}

