/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.ExprResult;

public class NumberResult
implements ExprResult {
    private double value = Double.NaN;

    public NumberResult() {
    }

    public NumberResult(double d) {
        this.value = d;
    }

    public boolean booleanValue() {
        return this.value != 0.0;
    }

    public boolean equals(ExprResult exprResult) {
        if (exprResult == null) {
            return false;
        }
        if (exprResult.getResultType() != this.getResultType()) {
            return false;
        }
        return this.value == exprResult.numberValue();
    }

    public short getResultType() {
        return 1;
    }

    public double numberValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public Object toJavaObject() {
        return new Double(this.value);
    }

    public String toString() {
        int n = (int)this.value;
        if (this.value == (double)n) {
            return String.valueOf(n);
        }
        return String.valueOf(this.value);
    }
}

