/**
 * The contents of this file are subject to the OpenXML Public
 * License Version 1.0; you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.openxml.org/license/
 *
 * THIS SOFTWARE AND DOCUMENTATION IS PROVIDED ON AN "AS IS" BASIS
 * WITHOUT WARRANTY OF ANY KIND EITHER EXPRESSED OR IMPLIED,
 * INCLUDING AND WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE
 * AND DOCUMENTATION IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGING. SEE THE LICENSE FOR THE
 * SPECIFIC LANGUAGE GOVERNING RIGHTS AND LIMITATIONS UNDER THE
 * LICENSE.
 *
 * The Initial Developer of this code under the License is
 * OpenXML.org. Portions created by OpenXML.org and/or Assaf Arkin
 * are Copyright (C) 1998, 1999 OpenXML.org. All Rights Reserved.
 */


package examples.changelog;


import java.util.*;
import org.w3c.dom.*;
import org.w3c.dom.fi.*;
import org.openxml.DOMFactory;
import org.openxml.x3p.*;
import org.openxml.source.*;
import org.openxml.dom.iterator.NamedNodeFilter;


/**
 * @version $Revision: 1.2 $ $Date: 1999/04/12 06:07:59 $
 * @author <a href="mailto:arkin@trendline.co.il">Assaf Arkin</a>
 */
public class ChangeLogFormatter
    implements ProcessorEngine
{


    public ChangeLogFormatter( ProcessContext ctx )
    {
        Source      source;
        Object      template;

        template = ctx.getObject( "changelog.formatter.template" );
        if ( template != null )
        {
            if ( template instanceof Document )
                _template = (Document) ( (Document) template ).cloneNode( true );
            else
            if ( template instanceof Source )
                _template = ( (Source) template ).getDocument();
            else
            if ( template instanceof String )
            {
                source = DOMFactory.newSource();
                source.setURI( (String) template );
                source.setDocClass( Source.DOCUMENT_HTML );
                _template = source.getDocument();
            }
            else
                _template = null;
        }
        if ( _template == null )
        {
            source = DOMFactory.newSource();
            source.setURI( ChangeLogProcessor.TEMPLATE_URI );
            source.setDocClass( Source.DOCUMENT_HTML );
            _template = source.getDocument();
        }

        if ( _template == null )
            throw new IllegalStateException( "Cannot retrieve formatting template" );

        _templateNew = stripSection( _template, "clone-new" );
        _templateChange = stripSection( _template, "clone-change" );
        _templateFix = stripSection( _template, "clone-fix" );
        _templateDead = stripSection( _template, "clone-dead" );
        _templateRelease = stripSection( _template, "clone-release" );

        ctx.setObject( "changelog.formatter.output", _template );
   }


    public int whatToProcess()
    {
        return ( PROCESS_ELEMENT | PROCESS_PI );
    }


    public Node process( ProcessContext ctx, Node tree )
    {
        Node            output;
        Element         elem;

        if ( tree.getNodeType() == Node.ELEMENT_NODE )
        {
            elem = (Element) tree;
            if ( elem.getTagName().equals( "releases" ) )
            {
                substitue( _template, "fill-document-title", elem.getAttribute( "name" ) );
                substitue( _template, "fill-make-date", new Date().toString() );
            }
            else
            if ( elem.getTagName().equals( "release" ) )
            {
                output = _templateRelease.cloneNode( true );
                substitue( output, "fill-date", elem.getAttribute( "date" ) );
                substitue( output, "fill-version", elem.getAttribute( "version" ) );
                _lastRelease = output;
                fillContents( _template, "fill-contents", output );
            }
            else
            if ( elem.getTagName().equals( "title" ) )
            {
                output = _lastRelease;
                substitue( output, "fill-title", elem.getFirstChild().getNodeValue() );
            }
            else
            if ( elem.getTagName().equals( "new" ) )
            {
                output = _templateNew.cloneNode( true );
                substitue( output, "fill-text", elem );
                fillContents( _lastRelease, "fill-contents", output );
            }
            else
            if ( elem.getTagName().equals( "change" ) )
            {
                output = _templateChange.cloneNode( true );
                substitue( output, "fill-text", elem );
                fillContents( _lastRelease, "fill-contents", output );
            }
            else
            if ( elem.getTagName().equals( "dead" ) )
            {
                output = _templateDead.cloneNode( true );
                substitue( output, "fill-text", elem );
                fillContents( _lastRelease, "fill-contents", output );
            }
            else
            if ( elem.getTagName().equals( "fix" ) )
            {
                output = _templateFix.cloneNode( true );
                substitue( output, "fill-text", elem );
                fillContents( _lastRelease, "fill-contents", output );
            }
        }
        return tree;
    }


    public void destroy( ProcessContext ctx )
    {
    }


    protected void substitue( Node tree, String lookFor, String with )
    {
        NodeIterator    iterator;
        Node            node;
        Node            text;

        iterator = piIterator( tree );
        node = iterator.nextNode();
        while ( node != null )
        {
            if ( node.getNodeValue().equals( lookFor ) )
            {
                if ( tree.getNodeType() == Node.DOCUMENT_NODE )
                    text = ( (Document) tree ).createTextNode( with );
                else
                    text = tree.getOwnerDocument().createTextNode( with );
                node.getParentNode().replaceChild( text, node );
            }
            node = iterator.nextNode();
        }
    }


    protected void substitue( Node tree, String lookFor, Node contents )
    {
        NodeIterator    iterator;
        Node            node;
        Node            cnode;
        Node            next;

        iterator = piIterator( tree );
        node = iterator.nextNode();
        while ( node != null )
        {
            if ( node.getNodeValue().equals( lookFor ) )
                node.getParentNode().replaceChild( contents.cloneNode( true ), node );
            node = iterator.nextNode();
        }
    }


    protected void fillContents( Node tree, String lookFor, Node contents )
    {
        NodeIterator    iterator;
        Node            node;
        Node            cnode;
        Node            next;

        iterator = piIterator( tree );
        node = iterator.nextNode();
        while ( node != null )
        {
            if ( node.getNodeValue().equals( lookFor ) )
                node.getParentNode().insertBefore( contents, node );
            node = iterator.nextNode();
        }
    }


    protected Node stripSection( Node tree, String sectionName )
    {
        NodeIterator    iterator;
        Node            node;
        Node            section;

        iterator = piIterator( tree );
        node = iterator.nextNode();
        while ( node != null )
        {
            if ( node.getNodeValue().equals( sectionName ) )
            {
                section = node.getNextSibling();
                // Hack to overcome whitespace in XML
                while ( section.getNodeType() == Node.TEXT_NODE )
                    section = section.getNextSibling();
                node.getParentNode().removeChild( section );
                node.getParentNode().removeChild( node );
                return section;
            }
            node = iterator.nextNode();
        }
        if ( tree.getNodeType() == Node.DOCUMENT_NODE )
            return ( (Document) tree ).createComment( "Section " + sectionName + " missing from template" );
        else
            return tree.getOwnerDocument().createComment( "Section " + sectionName + " missing from template" );
    }


    protected NodeIterator piIterator( Node tree )
    {
        return ( (NodeEx) tree ).createTreeIterator( NodeEx.TW_PI, NamedNodeFilter.lookup( "changelog" ) );
    }


    protected Node        _templateRelease;
    protected Node        _templateNew;
    protected Node        _templateDead;
    protected Node        _templateFix;
    protected Node        _templateChange;
    protected Document    _template;
    protected Node        _lastRelease;


}


