/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.util;

import org.openxml.util.StringPoolEntry;

public class FastStringPool {
    private static final int[] _primes = new int[]{3, 7, 11, 13, 29, 37, 47, 59, 71, 89, 107, 131, 163, 197, 239, 293, 353, 431, 521, 631, 761, 919, 1103, 1327, 1597, 1931, 2333, 2801, 3371, 4049, 4861, 5839, 7013, 8419, 10103, 12143, 14591, 17519, 21023, 25229, 30293, 36353, 43627, 52361, 62851, 75431, 90523, 108631, 130363, 156437, 187751, 225307, 270371, 324449, 389357, 467237, 560689, 672827, 807403, 968897, 1162687, 1395263, 1674319, 2009191, 2411033, 2893249};
    private static final int INITIAL_POOL_SIZE = 4861;
    private static final String EMPTY_STRING = "";
    private static final int MAX_POOL_STRING_LEN = 32;
    private static final int STRING_HASH_PRIME = 37;
    private static final boolean PHONG_HASH = true;
    private StringPoolEntry[] _pool;
    private int _firstEntryCount;
    private int _secondEntryCount;
    private int _maxPoolStringLength = 32;
    private boolean _phongHash = false;

    public FastStringPool() {
        this._pool = new StringPoolEntry[4861];
    }

    public FastStringPool(int n, int n2, boolean bl) {
        if (n < 64) {
            n = 64;
        }
        this._pool = new StringPoolEntry[FastStringPool.primeFromField(n)];
        this._maxPoolStringLength = n2;
        this._phongHash = bl;
    }

    public void enlargePool() {
        int n = this._pool.length;
        int n2 = 0;
        while (n2 < _primes.length) {
            n = _primes[n2];
            if (n > this._pool.length) break;
            ++n2;
        }
        if (n > this._pool.length) {
            StringPoolEntry[] stringPoolEntryArray = new StringPoolEntry[n];
            n2 = 0;
            while (n2 < this._pool.length) {
                StringPoolEntry stringPoolEntry = this._pool[n2];
                while (stringPoolEntry != null) {
                    this._pool[n2] = stringPoolEntry._next;
                    int n3 = this.hash(stringPoolEntry._string) % n;
                    stringPoolEntry._next = stringPoolEntryArray[n3];
                    stringPoolEntryArray[n3] = stringPoolEntry;
                    stringPoolEntry = this._pool[n2];
                }
                ++n2;
            }
            this._pool = stringPoolEntryArray;
        }
    }

    public int getFirstEntryCount() {
        return this._firstEntryCount;
    }

    public int getPoolSize() {
        return this._pool.length;
    }

    public int getSecondEntryCount() {
        return this._secondEntryCount;
    }

    protected int hash(String string) {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            n = 1673936089 * n + -1673936067 + string.charAt(n2);
            ++n2;
        }
        return n & Integer.MAX_VALUE;
    }

    public String lookup(String string) {
        StringPoolEntry stringPoolEntry;
        if (string == null || string.length() == 0) {
            return EMPTY_STRING;
        }
        if (string.length() > this._maxPoolStringLength) {
            return string;
        }
        int n = this.hash(string) % this._pool.length;
        StringPoolEntry[] stringPoolEntryArray = this._pool;
        synchronized (stringPoolEntryArray) {
            stringPoolEntry = this._pool[n];
            while (stringPoolEntry != null) {
                if (stringPoolEntry._string.equals(string)) {
                    String string2 = stringPoolEntry._string;
                    Object var6_6 = null;
                    return string2;
                }
                stringPoolEntry = stringPoolEntry._next;
            }
            stringPoolEntry = new StringPoolEntry();
            stringPoolEntry._string = string;
            stringPoolEntry._next = this._pool[n];
            this._pool[n] = stringPoolEntry;
            if (stringPoolEntry._next == null) {
                ++this._firstEntryCount;
            } else {
                ++this._secondEntryCount;
            }
        }
        return stringPoolEntry._string;
    }

    public String lookup(StringBuffer stringBuffer, int n, int n2) {
        StringPoolEntry stringPoolEntry;
        int n3 = n2 - n;
        if (stringBuffer == null || n3 <= 0) {
            return EMPTY_STRING;
        }
        if (n3 > this._maxPoolStringLength) {
            if (n3 == stringBuffer.length()) {
                return stringBuffer.toString();
            }
            char[] cArray = new char[n3];
            stringBuffer.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }
        char[] cArray = new char[n3];
        stringBuffer.getChars(n, n2, cArray, 0);
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            n4 = n4 * 37 ^ cArray[n5] - 32;
            ++n5;
        }
        n4 = (n4 & Integer.MAX_VALUE) % this._pool.length;
        StringPoolEntry[] stringPoolEntryArray = this._pool;
        synchronized (stringPoolEntryArray) {
            stringPoolEntry = this._pool[n4];
            while (stringPoolEntry != null) {
                if (stringPoolEntry._string.length() == n3) {
                    int n6 = n;
                    while (n6 < n2) {
                        if (stringBuffer.charAt(n6 - n) != cArray[n6]) break;
                        ++n6;
                    }
                    if (n6 == n2) {
                        String string = stringPoolEntry._string;
                        Object var11_13 = null;
                        return string;
                    }
                }
                stringPoolEntry = stringPoolEntry._next;
            }
            stringPoolEntry = new StringPoolEntry();
            stringPoolEntry._string = new String(cArray, 0, n3);
            stringPoolEntry._next = this._pool[n4];
            this._pool[n4] = stringPoolEntry;
            if (stringPoolEntry._next == null) {
                ++this._firstEntryCount;
            } else {
                ++this._secondEntryCount;
            }
        }
        return stringPoolEntry._string;
    }

    public String lookup(char[] cArray, int n, int n2) {
        StringPoolEntry stringPoolEntry;
        int n3 = n2 - n;
        if (cArray == null || n3 <= 0) {
            return EMPTY_STRING;
        }
        if (n3 > this._maxPoolStringLength) {
            return new String(cArray, n, n3);
        }
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            n4 = n4 * 37 ^ cArray[n5] - 32;
            ++n5;
        }
        n4 = (n4 & Integer.MAX_VALUE) % this._pool.length;
        StringPoolEntry[] stringPoolEntryArray = this._pool;
        synchronized (stringPoolEntryArray) {
            stringPoolEntry = this._pool[n4];
            while (stringPoolEntry != null) {
                if (this.match(stringPoolEntry._string, cArray, n, n2)) {
                    String string = stringPoolEntry._string;
                    Object var10_10 = null;
                    return string;
                }
                stringPoolEntry = stringPoolEntry._next;
            }
            stringPoolEntry = new StringPoolEntry();
            stringPoolEntry._string = new String(cArray, n, n3);
            stringPoolEntry._next = this._pool[n4];
            this._pool[n4] = stringPoolEntry;
            if (stringPoolEntry._next == null) {
                ++this._firstEntryCount;
            } else {
                ++this._secondEntryCount;
            }
        }
        return stringPoolEntry._string;
    }

    protected boolean match(String string, char[] cArray) {
        int n = cArray.length;
        if (string.length() != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != cArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean match(String string, char[] cArray, int n, int n2) {
        if (string.length() != n2 - n) {
            return false;
        }
        int n3 = n;
        while (n3 < n2) {
            if (string.charAt(n3 - n) != cArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected static int primeFromField(int n) {
        int n2 = _primes.length;
        while (n2-- > 0) {
            if (_primes[n2] > n) continue;
            return _primes[n2];
        }
        return 3;
    }
}

