/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openxml.util.Resources;
import org.openxml.x3p.Processor;
import org.openxml.x3p.ProcessorEngineCreator;
import org.openxml.x3p.ProcessorException;
import org.openxml.x3p.processors.ChainProcessor;
import org.openxml.x3p.processors.ChainProcessorCreator;
import org.openxml.x3p.processors.PIEngineRegistry;
import org.openxml.x3p.processors.SSIEngineCreator;

public abstract class ProcessorFactory {
    private static PIEngineRegistry _piRegistry = new PIEngineRegistry();
    private static Hashtable _creators = new Hashtable();

    static {
        ProcessorFactory.registerEngine("SSI", new SSIEngineCreator());
        ProcessorFactory.registerEngine("PI", _piRegistry);
        ProcessorEngineCreator[] processorEngineCreatorArray = new ProcessorEngineCreator[2];
        processorEngineCreatorArray[1] = new SSIEngineCreator();
        processorEngineCreatorArray[0] = _piRegistry;
        ProcessorFactory.registerEngine("default", new ChainProcessorCreator(processorEngineCreatorArray));
    }

    public static Processor createProcessor(Object object) throws ProcessorException {
        return ProcessorFactory.createProcessor(object, "default");
    }

    public static Processor createProcessor(Object object, String string) throws ProcessorException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";:");
        ProcessorEngineCreator[] processorEngineCreatorArray = new ProcessorEngineCreator[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            processorEngineCreatorArray[n] = (ProcessorEngineCreator)_creators.get(string2);
            if (processorEngineCreatorArray[n] == null) {
                throw new ProcessorException(Resources.format("Processor001", string2));
            }
            ++n;
        }
        return new ChainProcessor(object, processorEngineCreatorArray);
    }

    public static ProcessorEngineCreator findEngineCreator(String string) {
        return (ProcessorEngineCreator)_creators.get(string);
    }

    public static void registerEngine(String string, ProcessorEngineCreator processorEngineCreator) {
        if (string == null) {
            throw new NullPointerException(Resources.format("Error001", "creator"));
        }
        if (processorEngineCreator == null) {
            _creators.remove(string);
        } else {
            _creators.put(string, processorEngineCreator);
        }
    }

    public static void registerPIEngine(String string, ProcessorEngineCreator processorEngineCreator) {
        _piRegistry.registerPIEngine(string, processorEngineCreator);
    }
}

