/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom.html;

import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.ElementImpl;
import org.openxml.dom.NodeImpl;
import org.openxml.dom.html.HTMLDocumentImpl;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;

public class HTMLElementImpl
extends ElementImpl
implements HTMLElement {
    HTMLElementImpl(HTMLDocumentImpl hTMLDocumentImpl, String string) {
        super(hTMLDocumentImpl, string.toUpperCase());
    }

    String capitalize(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            cArray[0] = Character.toUpperCase(cArray[0]);
            int n = 1;
            while (n < cArray.length) {
                cArray[n] = Character.toLowerCase(cArray[n]);
                ++n;
            }
            return String.valueOf(cArray);
        }
        return string;
    }

    protected NodeImpl castNewChild(Node node) throws DOMException {
        if (node == null) {
            throw new DOMExceptionImpl(3, "Child reference is null.");
        }
        if (!(node instanceof NodeImpl)) {
            throw new DOMExceptionImpl(3, "Child is not a compatible type for this node.");
        }
        if (!(node instanceof ElementImpl || node instanceof Comment || node instanceof Text || node instanceof DocumentFragment || node instanceof ProcessingInstruction)) {
            throw new DOMExceptionImpl(3, "Child is not a compatible type for this node.");
        }
        return (NodeImpl)node;
    }

    String getCapitalized(String string) {
        char[] cArray;
        String string2 = this.getAttribute(string);
        if (string2 != null && (cArray = string2.toCharArray()).length > 0) {
            cArray[0] = Character.toUpperCase(cArray[0]);
            int n = 1;
            while (n < cArray.length) {
                cArray[n] = Character.toLowerCase(cArray[n]);
                ++n;
            }
            return String.valueOf(cArray);
        }
        return string2;
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getDir() {
        return this.getAttribute("dir");
    }

    public HTMLFormElement getForm() {
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof HTMLFormElement) {
                return (HTMLFormElement)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public String getLang() {
        return this.getAttribute("lang");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    void setAttribute(String string, boolean bl) {
        if (bl) {
            this.setAttribute(string, "");
        } else {
            this.removeAttribute(string);
        }
    }

    public void setClassName(String string) {
        this.setAttribute("class", string);
    }

    public void setDir(String string) {
        this.setAttribute("dir", string);
    }

    public void setId(String string) {
        this.setAttribute("id", string);
    }

    public void setLang(String string) {
        this.setAttribute("lang", string);
    }

    public void setTitle(String string) {
        this.setAttribute("title", string);
    }

    boolean toBoolean(String string) {
        return this.getAttribute(string) != null;
    }

    int toInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

