/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jde.debugger.JDEException;
import jde.debugger.JDENumberFormatException;
import jde.debugger.expr.ExpressionParser;
import jde.debugger.expr.ParseException;

public class Etc {
    public static void dump(Object obj) {
        if (obj instanceof Collection) {
            Iterator it = ((Collection)obj).iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        } else if (obj instanceof Object[]) {
            Object[] k = (Object[])obj;
            int i = 0;
            while (i < k.length) {
                Etc.dump(k[i]);
                ++i;
            }
        } else {
            System.out.println(obj);
        }
    }

    public static Long safeGetLong(Object obj, String type) throws JDEException {
        try {
            return new Long(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new JDENumberFormatException(type);
        }
    }

    public static int safeGetint(Object obj, String type) throws JDEException {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new JDENumberFormatException(type);
        }
    }

    public static Value evaluate(String expr, StackFrame frame) throws JDEException {
        try {
            ExpressionParser.GetFrame frameGetter = null;
            frameGetter = new ExpressionParser.GetFrame(frame){
                private final /* synthetic */ StackFrame val$frame;

                public StackFrame get() throws IncompatibleThreadStateException {
                    return this.val$frame;
                }
                {
                    this.val$frame = val$frame;
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            };
            return ExpressionParser.evaluate(expr, frame.virtualMachine(), frameGetter);
        }
        catch (NativeMethodException ex) {
            throw new JDEException("Can't access local variables in native methods");
        }
        catch (ParseException ex) {
            throw new JDEException("Parse error in expression. Are you accessing local variables without compiling with -g?");
        }
        catch (InvocationException ex) {
            throw new JDEException("Exception in expression: " + ex.exception().referenceType().name());
        }
        catch (InvalidTypeException ite) {
            throw new JDEException("Expression contains invalid type");
        }
        catch (IncompatibleThreadStateException itse) {
            throw new JDEException("This expression cannot be evaluated at an arbitrary location");
        }
        catch (ClassNotLoadedException tnle) {
            throw new JDEException("A required class for the evaluation hasn't been loaded");
        }
    }

    public static Object getThreadFromArgs(List args) throws JDEException {
        String threadArg = null;
        int threadIndex = -1;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i).toString().toLowerCase();
            if (arg.equals("on_thread_id") || arg.equals("on_thread_name") || arg.equals("-tid") || arg.equals("-tname")) {
                threadIndex = i;
                threadArg = args.remove(threadIndex).toString();
                break;
            }
            ++i;
        }
        if (threadArg == null) {
            return null;
        }
        if (threadArg.equals("on_thread_id") || threadArg.equals("-tid")) {
            if (threadIndex == args.size()) {
                throw new JDEException("Missing argument to 'on_thread_id'");
            }
            try {
                return new Long(args.remove(threadIndex).toString());
            }
            catch (NumberFormatException ex) {
                throw new JDENumberFormatException("'on_thread_id' argument");
            }
        }
        if (threadArg.equals("on_thread_name") || threadArg.equals("-tname")) {
            if (threadIndex == args.size()) {
                throw new JDEException("Missing argument to 'on_thread_name'");
            }
            return args.remove(threadIndex).toString();
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static String getExprFromArgs(List args) throws JDEException {
        String exprArg = null;
        int exprIndex = -1;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i).toString().toLowerCase();
            if (arg.equals("if") || arg.equals("-e")) {
                exprIndex = i;
                exprArg = args.remove(exprIndex).toString();
                break;
            }
            ++i;
        }
        if (exprArg == null) {
            return null;
        }
        if (exprArg.equals("if") || exprArg.equals("-e")) {
            if (exprIndex == args.size()) {
                throw new JDEException("Missing argument to 'if'");
            }
            return args.remove(exprIndex).toString();
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static List getClassFiltersFromArgs(List args) throws JDEException {
        String filterArg = null;
        int filterIndex = -1;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i).toString().toLowerCase();
            if (arg.equals("class_filters") || arg.equals("-cf")) {
                filterIndex = i;
                filterArg = args.remove(filterIndex).toString();
                break;
            }
            ++i;
        }
        if (filterArg == null) {
            return null;
        }
        if (filterArg.equals("class_filters") || filterArg.equals("-cf")) {
            if (filterIndex == args.size()) {
                throw new JDEException("Missing argument to 'class_filters'");
            }
            ArrayList<String> filters = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(args.remove(filterIndex).toString(), " \t\n\r\f,");
            while (tokens.hasMoreTokens()) {
                filters.add(tokens.nextToken());
            }
            return filters;
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static List getClassExFiltersFromArgs(List args) throws JDEException {
        String filterArg = null;
        int filterIndex = -1;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i).toString().toLowerCase();
            if (arg.equals("class_exclusion_filters") || arg.equals("-cef")) {
                filterIndex = i;
                filterArg = args.remove(filterIndex).toString();
                break;
            }
            ++i;
        }
        if (filterArg == null) {
            return null;
        }
        if (filterArg.equals("class_exclusion_filters") || filterArg.equals("-cef")) {
            if (filterIndex == args.size()) {
                throw new JDEException("Missing argument to 'class_exclusion_filters'");
            }
            ArrayList<String> filters = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(args.remove(filterIndex).toString(), " \t\n\r\f,");
            while (tokens.hasMoreTokens()) {
                filters.add(tokens.nextToken());
            }
            return filters;
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static int getSuspendPolicyFromArgs(List args) throws JDEException {
        String suspendPolicyArg = null;
        int suspendPolicyIndex = -1;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i).toString().toLowerCase();
            if (arg.equals("using_suspend_policy") || arg.equals("-sp")) {
                suspendPolicyIndex = i;
                suspendPolicyArg = args.remove(suspendPolicyIndex).toString();
                break;
            }
            ++i;
        }
        if (suspendPolicyArg == null) {
            return 2;
        }
        if (suspendPolicyArg.equals("using_suspend_policy") || suspendPolicyArg.equals("-sp")) {
            if (suspendPolicyIndex == args.size()) {
                throw new JDEException("Missing argument to 'using_suspend_policy'");
            }
            String policy = args.remove(suspendPolicyIndex).toString().toLowerCase();
            if (policy.equals("all")) {
                return 2;
            }
            if (policy.equals("thread")) {
                return 1;
            }
            if (policy.equals("none")) {
                return 0;
            }
            throw new JDEException("Invalid suspend policy '" + policy + "'");
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static Long getObjectIDFromArgs(List args) throws JDEException {
        String idArg = null;
        int idIndex = -1;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i).toString().toLowerCase();
            if (arg.equals("if_object_id") || arg.equals("-oid")) {
                idIndex = i;
                idArg = args.remove(idIndex).toString();
                break;
            }
            ++i;
        }
        if (idArg == null) {
            return null;
        }
        if (idArg.equals("if_object_id") || idArg.equals("-oid")) {
            if (idIndex == args.size()) {
                throw new JDEException("Missing argument to 'if_object_id'");
            }
            try {
                return new Long(args.remove(idIndex).toString());
            }
            catch (NumberFormatException ex) {
                throw new JDENumberFormatException("'if_object_id' argument");
            }
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }
}

