
import java.sql.*;
import java.io.*;


/**
 * test getting timestamps from the database.
 *
 */
public class t0001
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, IOException
   {
      boolean   passed = true;


      System.out.println("Starting test t0001-  Insert and retrieve timestamps");



      // open the database
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0001");
      }
      catch (SQLWarning e)
      {
         String okayError = "Cannot drop the table";

         if (! (e.getMessage().startsWith(okayError)))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate("create table t0001             " +
                                 "  (t1 datetime not null,       " +
                                 "   t2 datetime null,           " +
                                 "   t3 smalldatetime not null,  " +
                                 "   t4 smalldatetime null)");
      System.out.println("Creating table affected " + count + " rows");
    
      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0001 values (?, '1998-09-09 15:35:05',        " +
         "                          getdate(), '1998-09-09 15:35:00')");
    
      Timestamp   t0 = new Timestamp(98, 8, 9, 15, 35, 6, 400000000);
      pStmt.setTimestamp(1, t0);
      count = pStmt.executeUpdate();
      System.out.println("Added " + count + " rows");
    
      pStmt = cx.prepareStatement(
         "select max(t1), max(t2), max(t3), max(t4) from t0001");
    
      ResultSet  rs1 = stmt.executeQuery("select                            "+
                                         "max(t1), max(t2), max(t3), max(t4)"+
                                         " from t0001");
      ResultSet  rs2 = pStmt.executeQuery();
    
      if (!rs1.next())
      {
         System.out.println("stmt did not get any results.");
      }
      if (!rs2.next())
      {
         System.out.println("stmt did not get any results.");
      }

      Timestamp   t1 = rs1.getTimestamp(1);
      Timestamp   t2 = rs1.getTimestamp(2);
      Timestamp   t3 = rs1.getTimestamp(3);
      Timestamp   t4 = rs1.getTimestamp(4);
      Timestamp   t5 = rs2.getTimestamp(1);
      Timestamp   t6 = rs2.getTimestamp(2);
      Timestamp   t7 = rs2.getTimestamp(3);
      Timestamp   t8 = rs2.getTimestamp(4);

      System.out.println("t0 is " + t0);
      System.out.println("t1 is " + t1);
      System.out.println("t2 is " + t2);
      System.out.println("t3 is " + t3);
      System.out.println("t4 is " + t4);
      System.out.println("t5 is " + t5);
      System.out.println("t6 is " + t6);
      System.out.println("t7 is " + t7);
      System.out.println("t8 is " + t8);

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0001.\n");
      System.exit(passed ? 0 : 1);
   }
}

