# ts_tree.tcl
# Analysis of document tree

set params(treelist) {"\\include" "\\input"}
proc tree_analyse {file} {
  global params

  set fd [open $file r]
  puts $fd
  while {![eof $fd]} {
    gets $fd s
    puts $s
    foreach key $params(treelist) {
      while {[set i [string first $key $s]] != -1} {
        set i [expr $i + [string length $key]]
        set s [string range $s $i end]
	regexp {^[\{ ]([^\}\\ ]*)} $s dummy file
	puts "|$file|"
      }
    }
  } 
  close $fd
}
