/************************************************************************/
/*                                                                      */
/*                Centre for Speech Technology Research                 */
/*                     University of Edinburgh, UK                      */
/*                       Copyright (c) 1996,1997                        */
/*                        All Rights Reserved.                          */
/*                                                                      */
/*  Permission to use, copy, modify, distribute this software and its   */
/*  documentation for research, educational and individual use only, is */
/*  hereby granted without fee, subject to the following conditions:    */
/*   1. The code must retain the above copyright notice, this list of   */
/*      conditions and the following disclaimer.                        */
/*   2. Any modifications must be clearly marked as such.               */
/*   3. Original authors' names are not deleted.                        */
/*  This software may not be used for commercial purposes without       */
/*  specific prior written permission from the authors.                 */
/*                                                                      */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
/*  THIS SOFTWARE.                                                      */
/*                                                                      */
/************************************************************************/
/*                 Author: Alan W Black                                 */
/*                   Date: May 1997                                     */
/************************************************************************/
/*                                                                      */
/* Lets see if we can break the TokenStream class                       */
/*                                                                      */
/************************************************************************/

#include <stdlib.h>
#include "EST_Token.h"

static void find_tokens(EST_TokenStream &ts)
{
    // Count and display the tokens in this stream
    int tokens;

    for (tokens=0; !ts.eof(); tokens++)
	cout << ts.get().string() << endl;
    cout << "Total: " << tokens << endl << endl;;

}

int main(int argc,char **argv)
{
    // Simple program to read all the tokens in the named file
    // a print a summary of them
    (void)argc;
    (void)argv;
    EST_TokenStream ts;
    EST_String s;

    // Basic tokenizing tasks changing punctuation, whitespace and
    // single character symbols etc.
    s = "This is a test.";
    cout << "Test 1: " << quote_string(s) << endl;
    ts.open_string(s);
    find_tokens(ts);
    ts.close();

    s = "This (is) a test.";
    cout << "Test 2: " << quote_string(s) << endl;
    ts.open_string(s);
    find_tokens(ts);
    ts.close();

    s = "This (is) a test.";
    cout << "Test 3: " << quote_string(s) << endl;
    ts.open_string("This (is) a test.");
    ts.set_PrePunctuationSymbols("({[");
    ts.set_PunctuationSymbols(EST_Token_Default_PunctuationSymbols);
    find_tokens(ts);
    ts.close();

    s = "This (is) a test.";
    cout << "Test 4: " << quote_string(s) << endl;
    ts.open_string(s);
    ts.set_SingleCharSymbols("()");
    ts.set_PunctuationSymbols(EST_Token_Default_PunctuationSymbols);
    find_tokens(ts);
    ts.close();

    s = "This \"is a\" te\\\"st.";
    cout << "Test 5: " << quote_string(s) << endl;
    ts.open_string(s);
    ts.set_PrePunctuationSymbols(EST_Token_Default_PrePunctuationSymbols);
    ts.set_PunctuationSymbols(EST_Token_Default_PunctuationSymbols);
    find_tokens(ts);
    ts.close();

    s = "This \"is a\" te\\\"st.";
    cout << "Test 6: " << quote_string(s) << endl;
    ts.open_string(s);
    ts.set_quotes('"','\\');
    find_tokens(ts);
    ts.close();

    s = "This \"is \n\
a\" te\\\"st.";
    cout << "Test 7: " << quote_string(s) << endl;
    ts.open_string(s);
    ts.set_quotes('"','\\');
    find_tokens(ts);
    ts.close();

    return 0;
}


