/************************************************************************/
/*                                                                      */
/*                Centre for Speech Technology Research                 */
/*                     University of Edinburgh, UK                      */
/*                       Copyright (c) 1996,1997                        */
/*                        All Rights Reserved.                          */
/*                                                                      */
/*  Permission to use, copy, modify, distribute this software and its   */
/*  documentation for research, educational and individual use only, is */
/*  hereby granted without fee, subject to the following conditions:    */
/*   1. The code must retain the above copyright notice, this list of   */
/*      conditions and the following disclaimer.                        */
/*   2. Any modifications must be clearly marked as such.               */
/*   3. Original authors' names are not deleted.                        */
/*  This software may not be used for commercial purposes without       */
/*  specific prior written permission from the authors.                 */
/*                                                                      */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
/*  THIS SOFTWARE.                                                      */
/*                                                                      */
/************************************************************************/
/*                 Author: Richard Caley                                */
/*                   Date: May 1997                                     */
/************************************************************************/
#include "EST_String.h"
#include <iostream.h>
#include <stdio.h>

int main()
{
    EST_String example("hello world");
    EST_Regex exclamation("\\(wow\\|yey\\|lo\\)[^a-z]");

    cout << example << "\n";
    cout.flush();
    printf("stdio version %s\n", (const char *)example);
    fflush(stdout);

    if (example.contains(exclamation))
      cout << "\nYes, it contains a match for " << exclamation << "\n";

    // find a match and extract the thing in brackets
    int start_br[EST_Regex_max_subexpressions];
    int end_br[EST_Regex_max_subexpressions];
    int len;

    if (example.search(exclamation, len, 0, start_br, end_br)>=0)
      {
	// whole match is item 0
	cout << "match was '" << example.at(start_br[0], end_br[0]- start_br[0]) << "'\n";

	// first set of brackets.
	cout << " word was '" << example.at(start_br[1], end_br[1]- start_br[1]) << "'\n";
      }

    EST_String complex("what if I don't like 'hello world'?");

    EST_String quoted(complex.quote_if_needed('\''));
    EST_String unquoted(quoted.unquote_if_needed('\''));

    cout << "\n";
    cout << "start with \"" << complex << "\"\n";
    cout << "    quoted \"" << quoted << "\"\n";
    cout << "   unquoted \"" << unquoted << "\"\n";

    return 0;
}
