 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Fri May  9 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Track maps provide a mapping from symbolic track names to the        */
 /* actual position of the information within a track frame.             */
 /*                                                                      */
 /* Channel name maps map textual names for track channels to symbolic   */
 /* names, they are just a special case of named enums.                  */
 /*                                                                      */
 /************************************************************************/

#include "EST_TrackMap.h"

void EST_TrackMap::clear(void)
{
  for(int i=0; i<num_channel_types; i++)
    p_map[i]=NO_SUCH_CHANNEL;
}


void EST_TrackMap::init(void)
{
p_refcount=NOT_REFCOUNTED; 
clear(); 
}

EST_TrackMap::EST_TrackMap(void)
{
  init();
}


EST_TrackMap::EST_TrackMap(int dummy_value)
{
  (void)dummy_value;
  init();
  p_refcount=0;			// turn on refcounting
}

EST_TrackMap::EST_TrackMap(EST_ChannelMapping map)
{
  init();

  int i;
  for(i=0; map[i].type != channel_unknown; i++)
    set(map[i].type, map[i].channel);

}

EST_ChannelType EST_TrackMap::channel_type(unsigned short channel) const
{
unsigned short i;

for(i=0; i<num_channel_types;i++)
  if (p_map[i] == channel)
    return (EST_ChannelType)i;

return channel_unknown;
}

short EST_TrackMap::last_channel(void) const
{
  short last = -1;
  for(short i=0; i<num_channel_types;i++)
    if (p_map[i]> last)
      last = p_map[i];
  return last;
}


static EST_TValuedEnumDefinition<EST_ChannelType, const char *, NO_INFO> channel_name_tbl[] = {
  { channel_unknown,	{ "Unknown" }},
  { channel_order,	{ "Order" }},
  { channel_power,	{ "Power", "raw_power", "rms" }},
  { channel_peak,	{ "Peak", "ac_peak" }},
  { channel_duration,	{ "Duration" }},
  { channel_length,	{ "Length", "frame_len"}},
  { channel_f0,		{ "F0" }},
  { channel_voiced,	{ "Voiced", "prob_voice"}},
  { channel_frame,	{ "Frame"}},
  { channel_time,	{ "Time"}},
  { channel_coef0,	{ "Coefficient0", "spec_param" }},
  { channel_coefN,	{ "CoefficientN"}},
  { channel_unknown,	{ NULL }}
};

EST_ChannelNameMap EST_default_channel_names(channel_name_tbl);

static EST_TValuedEnumDefinition<EST_ChannelType, const char *, NO_INFO> esps_channel_name_tbl[] = {
  { channel_unknown,	{ "Unknown" }},
  { channel_order,	{ "Order" }},
  { channel_power,	{ "raw_power", "rms" }},
  { channel_peak,	{ "ac_peak" }},
  { channel_duration,	{ "Duration" }},
  { channel_length,	{ "frame_len"}},
  { channel_f0,		{ "F0" }},
  { channel_voiced,	{ "prob_voice"}},
  { channel_coef0,	{ "spec_param" }},
  { channel_unknown,	{ NULL }}
};

EST_ChannelNameMap esps_channel_names(esps_channel_name_tbl);

#if defined(INSTANTIATE_TEMPLATES)

#include "../base_class/EST_TNamedEnum.cc"

template class EST_TNamedEnum<EST_ChannelType>;
template class EST_TNamedEnumI<EST_ChannelType, NO_INFO>;
template class EST_TValuedEnum<EST_ChannelType,const char *>;
template class EST_TValuedEnumI<EST_ChannelType,const char *, NO_INFO>;

#endif
