/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  July 1994                                */
/*-----------------------------------------------------------------------*/
/*                    Smooth F0 contours                                 */
/*=======================================================================*/


#include <math.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include "EST_pda.h"
#include "array_smoother.h"
#include "EST_math.h"


void smooth_portion(EST_Track &c, EST_Option &op);
void interp(EST_Track c);
void interp(EST_Track &c, int *t, int n);
EST_Track interp(EST_Track &c, EST_Track &speech, int fill);

int parse_ms_list(EST_Option &a_list, struct Ms_Op *ms);

struct Ms_Op *default_ms_op(struct Ms_Op *ms);

EST_Track smooth_phrase(EST_Track &fz, EST_Track speech, EST_Option &op)
{
    int n;
    EST_Track smi_fz, sm_fz;
    char nstring[10];

    cout << "hello0\n";

    if (fz.empty())
	return fz;

//    cout << fz;

    sm_fz = fz;
    sm_fz.set_field_name("F0", 0);
//    speech.sample(fz.shift());

    n = (int)(op.fval("window_length", 1) / fz.shift());
    sprintf(nstring, "%d", n);
    op.override_val("point_window_size", nstring);

    cout << "hello1\n";
    smooth_portion(sm_fz, op);

    if (op.present("icda_no_interp"))
	return sm_fz; // no unvoiced interpolation

    int fill = op.present("icda_fi") ? 1 : 0;
    smi_fz = interp(sm_fz, speech, fill); // fill unvoiced region

    n = (int)(op.fval("second_length", 1) / fz.shift());
    sprintf(nstring, "%d", n);
    op.override_val("point_window_size", nstring);
    smooth_portion(smi_fz, op);
    cout << "hello4\n";

    return smi_fz;
}
struct Ms_Op *default_ms_op(struct Ms_Op *ms);

void smooth_portion(EST_Track &c, EST_Option &op)
{
    int i;
    float *a;
    struct Ms_Op *ms;
    ms = new Ms_Op;

    default_ms_op(ms);
    parse_ms_list(op, ms);

/*    cout << ms->smooth_double << endl;
    cout << ms->apply_hanning << endl;
    cout << ms->extrapolate << endl;
    cout << ms->first_median << endl;
    cout << ms->second_median << endl;
    cout << ms->window_length << endl;
    cout << ms->breaker << endl;
*/
//    cout << "smooth 1\n" << c;

    if (op.present("point_window_size"))
	ms->window_length = op.ival("point_window_size");

    a = new float[c.num_frames()];
    
//    cout << "smooth 2\n" << c;
    for (i = 0; i < c.num_frames(); ++i)
	a[i] = c.track_break(i) ? -1.0 : c.a(i);

//    for (i = 0; i < c.num_frames(); ++i)
//	cout << "a[" << i << "] " << a[i] << endl;
    
    array_smoother(a, c.num_frames(), ms);

//    for (i = 0; i < c.num_frames(); ++i)
//	cout << "a[" << i << "] " << a[i] << endl;
    
    for (i = 0; i < c.num_frames(); ++i)
    { //occasionally NaNs result...
	if (isnanf(a[i]))
	{
	    c.set_break(i);
	    c.a(i) = 0.0;
	}
	else
	{
	    if (a[i] < 0.0)
		c.set_break(i);
	    else
		c.set_value(i);
	    c.a(i) = a[i];
	}
    }
	delete a;
}

int should_fill(EST_Track &c, EST_Track &speech, int pos)
{
    int i, n, p;
    
    if (!c.track_break(pos))
	return 1;

    if (speech.a(pos) < 0.0)
	return 0;

    if ((n = c.next_non_break(pos)) == 0)
    {
//	cout << "pos " << c.t(pos) << " n " << n << endl;
//	cout << "2\n";
	return 0;
    }

    if ((p = c.prev_non_break(pos)) == 0)
    {
//	cout << "3\n";
	return 0;
    }

//    cout << "pos " << c.t(pos) << " n " << n << endl;

    for (i = pos; i < n; ++i)
    {
//	cout << "Checking for end " << c.t(i) << " s: " << speech.a(i) << endl;
	if (speech.a(i) < 0.0)
	{
//	    cout << "4\n";
	    return 0;
	}
    }

    for (i = pos; i > p; --i)
	  if (speech.a(i) < 0.0)
	  return 0;
//    cout << "here\n";
    return 1;
}

EST_Track interp(EST_Track &c, EST_Track &speech, int fill)
{
    int i, j, n, p;
    float m;
    EST_Track interp = c;

    //    cout << "here1 interp\n" << interp;
    //    cout << "here1 c\n" << interp;
    float f = interp.shift();
    //    cout << "here2\n";

    for (i = 1; i < interp.num_frames(); ++i)
    {
	if (!interp.track_break(i))
	    continue;

	p = i - 1;
	if ((n = interp.next_non_break(i)) == 0)
	    n = interp.num_frames() - 1;
	m = (interp.a(n) - interp.a(p)) / ( interp.t(n) - interp.t(p));

	if (fill || should_fill(interp, speech, i))
	{
	    for (j = 1; j < (n - p); ++j, ++i)
	    {
		interp.a(i) = (m * (float)j * f) + interp.a(p);
		interp.set_value(i);
	    }
	    if (n < (interp.num_frames() - 1))
		--i;
	}
	else
	    for (j = 1; j < (n - p); ++j, ++i)
		interp.set_break(i);
    }
    return interp;
}

int parse_ms_list(EST_Option &al, struct Ms_Op *ms)
{
    default_ms_op(ms);
    
    if (al.present("smooth_double"))
	ms->smooth_double = al.ival("smooth_double");
    if (al.present( "hanning"))
	ms->apply_hanning = al.ival("hanning");
    if (al.present("extrapolate"))
	ms->extrapolate = al.ival("extrapolate");
    if (al.present("first_length"))
	ms->first_median = al.ival("first_length");
    if (al.present("second_length"))
	ms->second_median = al.ival("second_length");
    if (al.present("window_length"))
	ms->window_length = al.ival("window_length");

    return 0;
}
