/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                    Copyright (c) 1994,1995,1996                       */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author: Paul Taylor                             */
/*                       Date  : October 1994                            */
/*-----------------------------------------------------------------------*/
/*                   EST_Track comparison main file                      */
/*                                                                       */
/*=======================================================================*/

#include "EST.h"

int main(int argc, char *argv[])
{
    EST_Track fz;
    EST_String out_file("-");
    EST_StrList files;
    EST_Option al;
    EST_Track ref, test, out;
    EST_FVector cv;

    print_help(argc, argv); 

    parse_command_line(argc, argv, "-abs -cor -diff -otype:s -relax:i -rms \n\
                -s:f -silent -short", files, al);

    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";

    if (ref.load(files.first(), al.fval("-s", 0)) != read_ok)
	    exit (0);
    if (test.load(files.item(1), al.fval("-s", 0)) != read_ok)
	    exit (0);

    if (al.present("-diff"))
    {
	out = difference(ref, test);
	absolute(out);
	out.set_contour_type(EST_ContourType::DIFFERENCE);
	out.save(out_file, al.val("-otype", 0));
    }
    else if (al.present("-rms"))
    {
	cv = rms_error(ref, test);
	cout << "RMS error is " << cv << endl;
    }
    else if (al.present("-cor"))
    {
	cv = correlation(ref, test);
	cout << "Correlation is " << cv << endl;
    }
    else if (al.present("-abs"))
    {
	cv = abs_error(ref, test);
	cout << "Absolute error is " << cv << endl;
    }
    else
    {
	out = error(ref, test, al.present("-relax") ? al.ival("-relax") : 0);
	if (al.present("-short"))
	    out.set_num_frames(Lof(ref.num_frames(), test.num_frames()));

	cout << "Unknown error information required" << endl;
    }
    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    (void)a_list;
    (void)al;
}

void print_help(int argc, char *argv[])
{
    for (int i = 0; i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "comp_track <ref file> <test file> <options>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << "-h      options help\n";
	    cout << "-abs     output absolute difference between two tracks\n";
	    cout << "-cor     output correlation between two tracks\n";
	    cout << "-diff    output difference between two tracks\n";
	    cout << "-otype  <output file type 'xmg' 'ascii' 'esps' 'htk'>\n";
	    cout << "-relax   <int> number of ignored frames\n";
	    cout << "-rms     output rms difference between two tracks\n";
	    cout << "-s       <float> frame spacing\n";
	    cout << "-silent  just print out % correct\n";
	    cout << "-short   only compare values which appear in both files\n";
	    exit (0);
	}
}
