/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                    Copyright (c) 1994,1995,1996                       */
/*                         All Rights Reserved.                          */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Paul Taylor                             */
/*                     Date   :  September 1994                          */
/*-----------------------------------------------------------------------*/
/*                     EST_Option Class header file                      */
/*                                                                       */
/*=======================================================================*/

#ifndef __EST_OPTION_H__
#define __EST_OPTION_H__

#include "EST_String.h"
#include "EST_KV.h"
#include "EST_rw_status.h"

class EST_Option: public KVL<EST_String, EST_String> {
public:
    // add prefix to every key name.
    void add_prefix(EST_String prefix);
    void remove_prefix(EST_String prefix);
    
    // read keyval list from file.
    EST_read_status load(const EST_String &name, const EST_String &comment = ";");

    // add to end of list or overwrite. If rval is empty, do nothing
    int override_val(const EST_String rkey, const EST_String rval);
    int override_fval(const EST_String rkey, const float  rval);
    int override_ival(const EST_String rkey, const int rval);
    
    // return value of correct type relating to key. By default,
    // an error occurs if the key is not present. Use m=0 if
    // to get a dummy value returned if key is not present

    int ival(const EST_String &rkey, int m=1);
    double dval(const EST_String &rkey, int m=1);
    float fval(const EST_String &rkey, int m=1);
    EST_String sval(const EST_String &rkey, int m=1);
    EST_String val(const EST_String &rkey, int m=1) { return sval(rkey,m); }
    
    int add_iitem(const EST_String &rkey, const int &rval);
    int add_fitem(const EST_String &rkey, const float &rval);
    
    friend  ostream& operator << (ostream& s, const EST_Option &kv);
};

#endif // __EST_OPTION_H__
