;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Walk about an utterance using features, relations etc.

(set! utt1 (Utterance Text "hello, example has three syllables."))
(utt.synth utt1)

(format t "num syllables: %d\n"
	(length (utt.features utt1 'Syllable '(name))))

(set! segs (utt.stream utt1 'Segment))
(set! s1 (car (utt.streamitem.rel utt1 (car (cdr segs)) 'Syllable)))
(set! s2 (car (utt.streamitem.rel utt1 (car (cdr (cdr segs))) 'Syllable)))
(set! s3 (car (utt.streamitem.rel utt1 (nth 4 segs) 'Syllable)))

(if (equal? s1 s2)
    (print "syls match: ok")
    (print "syls don't match: error"))
(if (not (equal? s2 s3))
    (print "syls don't match: ok")
    (print "syls match: error"))

(print
 (list
  (utt.streamitem.feat utt1 s3 'name)
  (utt.streamitem.feat utt1 s3 'Segment.name)
  (utt.streamitem.feat utt1 s3 'n.Segment.name)
  (utt.streamitem.feat utt1 s3 'p.Segment.name)
  (utt.streamitem.feat utt1 s3 'Word.name)
  (utt.streamitem.feat utt1 s3 'Word.Syllable.Segment:last.name)
  (utt.streamitem.feat utt1 s3 'Word.Token.whitespace)
  (utt.streamitem.feat utt1 s3 'Word.n.Token.p.punc)
  (utt.streamitem.feat utt1 s3 'addr)
  (utt.streamitem.feat utt1 s3 'p.addr)
  (utt.streamitem.feat utt1 s3 'pp.addr)
))



