 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Thu Aug 14 1997                               */
 /* --------------------------------------------------------------------  */
 /* Look for subtypes of a given type defined in any module.              */
 /*                                                                       */
 /* Walks over the directory tree looking for header files with names     */
 /* which match ".*Type.h" and looks in them for class                    */
 /* definitions. Outputs definitions of subtype tables.                   */
 /*                                                                       */
 /*************************************************************************/

#include "EST.h"
#include "EST_String.h"
#include "EST_Pathname.h"
#include "EST_error.h"

#define BUFFER_SIZE (1024)

void output_type_start(EST_String base_type)
{
  
  cout << "static SubtypedObject<" << base_type << ">::Subtype " << base_type << "_subtypes[] = {\n";

}

void output_type_include(EST_String base_type)
{
  cout << "#include \"" << base_type << ".h\"\n";
}

void output_subtype_include(EST_Pathname dir, EST_String base_type, EST_String sub_type)
{
  cout << "#include \"" << EST_String(dir) + EST_String(sub_type + base_type) << ".h\"\n";
}

void output_subtype_entry(EST_String base_type, EST_String sub_type)
{
  cout << "    { \"" << sub_type << "\", " << sub_type << base_type << "::recognise, " << sub_type << base_type << "::create },\n";
}

void output_type_end(EST_String base_type)
{
  (void) base_type;
  cout << "    { NULL, NULL, NULL }\n";
  cout << "  };\n";
  cout << "const SubtypedObject<" << base_type << ">::Subtype *SubtypedObject<" << base_type << ">::subtypes = " << base_type << "_subtypes;\n";
}

void find_below(EST_Pathname dir, EST_String base_type, EST_Regex &file_re, EST_Regex &class_re, EST_StrList &dirs, EST_StrList &subtypes)
{
  EST_StrList entries(dir.entries());

  EST_Litem *item;

  for(item=entries.head(); item; item=next(item))
    {
      EST_Pathname entry = entries(item);

      if (entry != "./" && entry != "../" && entry.is_dirname())
	  find_below(dir + entry, base_type, file_re, class_re, dirs, subtypes);
      else if (entry.matches(file_re))
	{
	  FILE *f;
	  char buffer[BUFFER_SIZE];

	  if ((f=fopen(dir + entry, "r"))==NULL)
	    EST_sys_error("can't read '%s'", (const char *)(dir + entry));

	  while(fgets(buffer, BUFFER_SIZE, f) != NULL)
	    {
	      EST_String line(buffer);
	      int start_br[EST_Regex_max_subexpressions];
	      int end_br[EST_Regex_max_subexpressions];
	      int len;

	      if (line.search(class_re, len, 0, start_br, end_br)>=0)
		{
		  EST_String sub_type(line.at(start_br[1], end_br[1]- start_br[1]));
		  cerr << " " <<  sub_type;

		  dirs.append(dir);
		  subtypes.append(sub_type);
		}
	    }

	  fclose(f);
	}
    }
}

int main(int argc, char *argv[])
{
  if (argc <3)
    EST_error("Useage: find_inits DIRECTORY ..."); 

  argv+=1;
  argc-=1;

  cout << "\n";
  cout << "/* This file is autogenerated by src/modules/Makefile */\n";
  cout << "\n";
  cout << "#include \"EST_unix.h\"\n";
  cout << "#include \"stdio.h\"\n";
  cout << "#include \"festival.h\"\n";

  for(int i=0; i<argc; i++)
    {
      EST_String dir(argv[i]);
      cout <<  "void festival_" << dir << "_init(void);\n";
    }
  cout << "\n";
  cout << "void festival_init_modules(void)\n";
  cout << "{\n";
  for(int i2=0; i2<argc; i2++)
    {
      EST_String dir(argv[i2]);
      cout << "   festival_" << dir << "_init();\n";
    }
  cout << "}\n";
  return 0;
}






