/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Alan W Black                                    */
/*             Date   :  November 1996                                   */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  Support for general user tts modes                                   */
/*  Each mode consists of user definable parameters for (at least) the   */
/*  the following                                                        */
/*    filter   external Unix program filter                              */
/*    utterance chunk tree:  decision tree to determine end of utterance */
/*    punctuation                                                        */
/*    whitespace                                                         */
/*    token analysis rule                                                */
/*    init function          run before mode is applied                  */
/*    exit function        run after mode is applied                     */
/*                                                                       */
/*=======================================================================*/
#include <stdio.h>
#include "EST_unix.h"
#include "festival.h"
#include "text.h"
#include "lexicon.h"

static void um_apply_filter(const EST_String &filtername,const EST_String &infile,
			    const EST_String &outname);

void tts_file_user_mode(LISP filename, LISP params)
{
    EST_String tmpname = make_tmp_filename();
    EST_String inname = get_c_string(filename);
    EST_String filter;
    EST_TokenStream ts;
    LISP func;

    func = get_param_lisp("init_func",params,NIL);
    if (func != NIL) 
	leval(cons(func,NIL),NIL);   // run initial function if specified

    filter = get_param_str("filter",params,"cat");
    um_apply_filter(filter,inname,tmpname);

    if (streq("xxml",get_param_str("analysis_type",params,"")))
	tts_file_xxml(strintern(tmpname));
    else
	tts_file_raw(strintern(tmpname));

    unlink(tmpname);

    func = get_param_lisp("exit_func",params,NIL);
    if (func != NIL)
	leval(cons(func,NIL),NIL);   // run end function if specified

}

static void um_apply_filter(const EST_String &filtername,const EST_String &infile,
			    const EST_String &outname)
{
    // filter the file into standard form
    EST_String command;

    if (access(infile,R_OK) != 0)
    {
	cerr << "TTS user mode: \"" << infile << "\" cannot be accessed" <<
	    endl;
	festival_error();
    }

    command = filtername + " " + infile + " > " + outname;
    system(command);  // should test if this is successful or not
}

