/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Alan W Black                                    */
/*             Date   :  February 1997                                   */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  Private functions for lexicon directory                              */
/*                                                                       */
/*=======================================================================*/
#ifndef __LEXICONP_H__
#define __LEXICONP_H__

EST_Val ff_word_gpos(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_cf(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_cap(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_contentp(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_n_content(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_nn_content(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_p_content(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_word_pp_content(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_syl_reduced(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_syl_lex_vowel(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_syl_onset_type(EST_Utterance &u,EST_Stream_Item &s);
EST_Val ff_syl_coda_type(EST_Utterance &u,EST_Stream_Item &s);
LISP lexicon_compile(LISP finname, LISP foutname);

#endif /* __LEXICONP_H__ */



