 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Tue Aug 26 1997                               */
 /* --------------------------------------------------------------------  */
 /* Machine readable descriptions of modules. Useful for help messages    */
 /* and for verifying that all is OK.                                     */
 /*                                                                       */
 /*************************************************************************/


#ifndef __MODULEDESCRIPTION_H__
#define __MODULEDESCRIPTION_H__

#include <stdio.h>
#include <iostream.h>
#include "EST_String.h"

#define MD_MAX_DESCRIPTION_LINES (10)
#define MD_MAX_INPUT_STREAMS (5)
#define MD_MAX_OPTIONAL_STREAMS (5)
#define MD_MAX_OUTPUT_STREAMS (5)
#define MD_MAX_PARAMETERS (10)

struct ModuleDescription {
  const char * name;		// name of module
  float version;		// version number of module
  const char * organisation;	// where it comes from
  const char * author;		// person(s) responsible

  const char * description[MD_MAX_DESCRIPTION_LINES];	// general description

  struct stream_parameter {
    const char * name;		// default stream name
    const char * description;	// what itis used for
  }   input_streams[MD_MAX_INPUT_STREAMS],
      optional_streams[MD_MAX_OPTIONAL_STREAMS],
      output_streams[MD_MAX_OUTPUT_STREAMS];

  struct parameter {
    const char * name;
    const char * type;		// Should be one of the ones defined below
    const char * default_val;
    const char * description;
  }   parameters[MD_MAX_PARAMETERS];
};

// Use these for types to avoid types and to allow for a cleverer system
// at a later date.

#define mpt_other	"OTHER"
#define mpt_bool	"BOOL"
#define mpt_natnum	"NATNUM"
#define mpt_int		"INT"
#define mpt_float	"FLOAT"
#define mpt_string	"STRING"
#define mpt_unitdatabase "UNITDATABASE"

EST_String to_string(const ModuleDescription &desc);

ostream &print(ostream &s, const ModuleDescription &desc);

int print(FILE *s, const ModuleDescription &desc);

ostream &operator << (ostream &stream, const ModuleDescription &desc);

#endif
