 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon June 30th 1997                           */
 /* ------------------------------------------------------------------   */
 /* Class of joins between units.                                        */
 /*                                                                      */
 /************************************************************************/

class Join;

#ifndef __JOIN_H__
#define __JOIN_H__

#include "EST.h"
#include "EST_TVector.h"
#include "SubtypedObject.h"
#include "Unit.h"

class Join : public SubtypedObject<Join> {

private:

  Unit *p_before;
  Unit *p_after;

protected:

  void set_before(Unit *u) { p_before = u; };
  void  set_after(Unit *u) { p_after  = u; };
  void set_before(Unit &u) { p_before = &u; };
  void  set_after(Unit &u) { p_after  = &u; };

public:

  Join(void);
  virtual ~Join(void); 

  // interface defined for subtypes.
  virtual EST_read_status fill_from(FILE *stream, int binary=1);
  virtual EST_write_status write_to(FILE *stream, int binary=1);

  virtual int set_property(EST_String property, ValueType value);

  void set_filename(EST_String);

  Unit *before(void) const { return p_before; };
  Unit *after(void)  const { return p_after; };

  virtual int from_point(void);	// point in prev unit to switch to join

  virtual int length(void);			// in arbitrary units;
  virtual EST_TVector<int> segment_ends(void);  // in the same units
  
  virtual int to_point(void);	// point in next unit to resume

#if defined(INCLUDE_LISP)
  //lisp interface
  static void lisp_declare(void);
#endif

  friend class SubtypedObject<Join>;
};


#endif
