;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   Some basic functions used in tests for Festival
;;;   

(define (test_words text)
"(test_words TEXT)
prints TEXT, Synthesizes TEXT and outputs the words in it."
  (format t "Word test: %s: " text)
  (set! utt1 (utt.synth (eval (list 'Utterance 'Text text))))
  (mapcar
   (lambda (word) (format t "%s " (car word)))
   (utt.features utt1 'Word '(name)))
  (format t "\n")
  t)

(define (test_segments text)
"(test_segments TEXT)
prints TEXT, Synthesizes TEXT and outputs the segments in it."
  (format t "Segment test: %s\n" text)
  (set! utt1 (utt.synth (eval (list 'Utterance 'Text text))))
  (utt.save.stream utt1 'Segment "-"))

(define (test_phrases text)
"(test_phrases TEXT)
prints TEXT, Synthesizes TEXT and outputs the words and phrase breaks."
  (format t "Phrase test: %s :\n" text)
  (set! utt1 (utt.synth (eval (list 'Utterance 'Text text))))
  (mapcar
   (lambda (word) 
     (format t "%s " (car word))
     (if (not (string-equal (car (cdr word)) (car (cdr (cdr word)))))
	 (format t "B ")))
   (utt.features utt1 'Word '(name Phrase.addr n.Phrase.addr)))
  (format t "\n")
  t)


(define (durasstr utt item)
"(durasstr UTT ITEM)
Returns duration as a string so that reasonable comparisons may be
made."
  (format nil "%1.6f" (utt.stream.feat utt item 'duration)))

(define (endasstr utt item)
"(endasstr UTT ITEM)
Returns duration as a string so that reasonable comparisons may be
made."
  (format nil "%1.6f" (utt.stream.feat utt item 'end)))

(define (test_tokens)
"(test_tokens)
Test some tokenization of a string."
 (let (actual)
  (set! utt1 (Utterance Text "On May 5 1985, around 1985 people joined Mr. Black's project."))
  (utt.synth utt1)
  (if (not (equal? 
	    (set! actual (utt.features utt1 'Token '(name punc whitespace)))
	    '(("On" "0" "")
	      ("May" "0" " ")
	      ("5" "0" " ")
	      ("1985" "," " ")
	      ("around" "0" " ")
	      ("1985" "0" " ")
	      ("people" "0" " ")
	      ("joined" "0" " ")
	      ("Mr" "0" " ")
	      ("Black's" "0" " ")
	      ("project" "." " "))))
      (error "test_tokens: failed to tokenize: " actual))
  (if (not (equal? 
	    (set! actual (utt.features utt1 'Word '(name pos)))
	    '(("On" "in")
	      ("May" "n")
	      ("fifth" "n")
	      ("nineteen" "n")
	      ("eighty" "n")
	      ("five" "cd")
	      ("around" "in")
	      ("one" "cd")
	      ("thousand" "n")
	      ("nine" "cd")
	      ("hundred" "cd")
	      ("and" "cc")
	      ("eighty" "r")
	      ("five" "cd")
	      ("people" "n")
	      ("joined" "v")
	      ("Mr" "n")
	      ("Black" "n")
	      ("'s" "pos")
	      ("project" "n"))))
      (error "test_tokens: failed token to word" actual))
  (if (not (equal? 
	    (set! actual (utt.features 
			  utt1 'Segment 
			  '(name lisp_durasstr Target.name
				 Target.lisp_endasstr)))
	    '(("#" "0.190000" 0 0)
	      ("o" "0.079692" "99.187" "0.190000")
	      ("n" "0.049558" 0 0)
	      ("m" "0.052607" "99.645" "0.319250")
	      ("ei" "0.124449" "98.844" "0.434082")
	      ("f" "0.102929" "97.679" "0.496306")
	      ("i" "0.064953" "94.712" "0.631712")
	      ("f" "0.093412" 0 0)
	      ("th" "0.072272" 0 0)
	      ("n" "0.047427" "96.792" "0.829871")
	      ("ai" "0.127638" "104.449" "0.941118")
	      ("n" "0.050915" 0 0)
	      ("t" "0.061083" 0 0)
	      ("ii" "0.094017" "104.136" "1.116934")
	      ("n" "0.047427" 0 0)
	      ("ei" "0.133834" "96.613" "1.258378")
	      ("t" "0.059516" 0 0)
	      ("ii" "0.092471" "90.926" "1.451729")
	      ("f" "0.097777" "88.362" "1.544200")
	      ("ai" "0.223190" "84.181" "1.753572")
	      ("v" "0.087914" "89.596" "1.953081")
	      ("#" "0.190000" 0 0)
	      ("@" "0.043630" "96.734" "2.143081")
	      ("r" "0.060156" 0 0)
	      ("au" "0.149608" "108.624" "2.246867")
	      ("n" "0.052793" 0 0)
	      ("d" "0.042380" 0 0)
	      ("w" "0.045244" "111.428" "2.491647")
	      ("uh" "0.075670" "100.484" "2.574727")
	      ("n" "0.069575" 0 0)
	      ("th" "0.099754" "97.160" "2.682137")
	      ("au" "0.163489" "90.493" "2.863636")
	      ("z" "0.059075" 0 0)
	      ("n" "0.072418" 0 0)
	      ("d" "0.039651" 0 0)
	      ("n" "0.047427" "90.937" "3.116524")
	      ("ai" "0.142875" "88.764" "3.235389")
	      ("n" "0.055783" 0 0)
	      ("h" "0.064664" "90.362" "3.362609")
	      ("uh" "0.074028" "86.886" "3.464287")
	      ("n" "0.050078" 0 0)
	      ("d" "0.042254" 0 0)
	      ("r" "0.031873" "88.997" "3.593633")
	      ("@" "0.034018" "88.861" "3.642515")
	      ("d" "0.040591" 0 0)
	      ("a" "0.109232" "89.463" "3.700115")
	      ("n" "0.054929" 0 0)
	      ("d" "0.049305" 0 0)
	      ("ei" "0.136355" "90.457" "3.913580")
	      ("t" "0.059516" 0 0)
	      ("ii" "0.093871" "98.809" "4.109451")
	      ("f" "0.101588" "91.866" "4.203322")
	      ("ai" "0.114827" "83.244" "4.362324")
	      ("v" "0.050815" 0 0)
	      ("p" "0.108976" "83.736" "4.470551")
	      ("ii" "0.088724" "77.649" "4.623889")
	      ("p" "0.107671" 0 0)
	      ("l" "0.097755" "82.951" "4.873678")
	      ("#" "0.190000" 0 0)
	      ("jh" "0.094311" "95.509" "5.063678")
	      ("oi" "0.183302" "105.057" "5.249640")
	      ("n" "0.052793" 0 0)
	      ("d" "0.039650" 0 0)
	      ("m" "0.066278" "107.738" "5.433734")
	      ("i" "0.051158" "111.921" "5.525591")
	      ("s" "0.102582" 0 0)
	      ("t" "0.059340" "109.274" "5.653752")
	      ("@" "0.034018" "100.151" "5.730101")
	      ("b" "0.076607" "97.874" "5.747109")
	      ("l" "0.039783" 0 0)
	      ("a" "0.109474" "92.490" "5.918237")
	      ("k" "0.072246" 0 0)
	      ("s" "0.095582" "89.653" "6.045220")
	      ("p" "0.111499" "86.492" "6.140803")
	      ("r" "0.042199" 0 0)
	      ("o" "0.090485" "91.598" "6.339743")
	      ("jh" "0.088804" 0 0)
	      ("e" "0.093630" "91.493" "6.473790")
	      ("k" "0.051373" 0 0)
	      ("t" "0.095246" "78.772" "6.714039")
	      ("#" "0.380000" 0 0))))
      (error "test_tokens: failed sgements duration or targets: " actual))
  t))

(set! tests (list test_tokens))

(define (festtest)
"(do_tests)
Run some tests of the system for regression purposes."
   (mapcar
    (lambda (x) (x))
    tests)
   t)

(provide 'festtest)
