/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: mem.c,v 3.10 1997/09/13 17:55:13 erik Rel $";
#endif

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "z80.h"
#include "resource.h"
#include "io.h"
#include "util.h"
#include "mem.h"
#if defined(SUN_AUDIO) || defined(XBELL_AUDIO)
#include "audio.h"
#endif
#include "emul.h"
#ifdef XZX_IF1
#include "if1.h"
#endif
#include "loadsave.h"


static int loadRomImage(char *, int);


int RealPageNumbers[4];
uns8 *TheMemory[4];
uns8 *RealMemory[NPAGES];


void
MemoryInit(void)
{
	int i;
	for (i = 0; i < NPAGES; i++)
	{
		RealMemory[i] = (uns8 *)Malloc(XZX_PAGESIZE, "MemoryInit");
	}
}

void
InitPages(void)
{
	PageIn(0, ROM0);
	PageIn(1, RAM5);
	PageIn(2, RAM2);
	PageIn(3, RAM0);
}

void
PageIn(int frame, int rpage)
{

#ifdef XZX_PLUS3
	assert(frame || rpage < RAM0 || GETCFG(machine) == 3);
#else
	assert(frame || rpage < RAM0);
#endif
	TheMemory[frame] = RealMemory[rpage];
	RealPageNumbers[frame] = rpage;
#ifdef XZX_PLUS3

	if (GETCFG(machine) == 3 && !frame && rpage < RAM0)
	{
		PageIn(1, RAM5);
		PageIn(2, RAM2);
		PageIn(3, RAM0 + (Last0x7FFD & B_SELRAM));
	}
#endif
}

static int
loadRomImage(char *image, int page)
{
	FILE *ifp;
	size_t nread;
	if (!(ifp = Fopen(image, "rb")))
	{
		Msg(M_PERR, "couldn't open ROM image <%s> for reading", image);
		return -1;
	}
	nread = fread(RealMemory[page], 1, XZX_PAGESIZE, ifp);

	if (nread != XZX_PAGESIZE && nread != XZX_PAGESIZE / 2)
	{
		Msg(M_WARN, "ROM image <%s> is only %d bytes", image, nread);
	}
	(void)fclose(ifp);
	return 0;
}

int
ReadROMs(void)
{
	int ret = 0;
#ifdef XZX_PLUS3
	assert(GETCFG(machine)==48 || GETCFG(machine)==128 || GETCFG(machine==3));
#else
	assert(GETCFG(machine)==48 || GETCFG(machine)==128);
#endif
	switch(GETCFG(machine))
	{
		case 48:
			ret |= loadRomImage(GETCFG(rom48), ROM0);
			break;
		case 128:
			ret |= loadRomImage(GETCFG(rom128_0), ROM0);
			ret |= loadRomImage(GETCFG(rom128_1), ROM1);
			break;
#ifdef XZX_PLUS3
		case 3:
			ret |= loadRomImage(GETCFG(rompl3_0), ROM0);
			ret |= loadRomImage(GETCFG(rompl3_1), ROM1);
			ret |= loadRomImage(GETCFG(rompl3_2), ROM2);
			ret |= loadRomImage(GETCFG(rompl3_3), ROM3);
			break;
#endif
	}
	BasicRom = GET_BASIC_ROM(GETCFG(machine));
	if (!ret)
	{
		BasicRom = GET_BASIC_ROM(GETCFG(machine));
		SetLoadSaveTraps();
#ifdef XBELL_AUDIO
		SetBeepTrap();
#endif
#ifdef XZX_IF1
#ifdef XZX_PLUS3

		assert(!(GETCFG(if1_active) && GETCFG(machine) == 3));
#endif
		if (GETCFG(if1_active))
		{
			if (loadRomImage(GETCFG(if1_rom), IF1ROM) == -1)
			{
				Msg(M_INFO, "IF1 emulation disabled");

				SETCFG(if1_active, False);
			}
			else
			{
				SetRS232Traps();
			}
		}
#endif
#ifdef XZX_MF128
#ifdef XZX_PLUS3

		assert(!(GETCFG(mf128_active) && GETCFG(machine) == 3));
#endif
		if (GETCFG(mf128_active))
		{
			if (loadRomImage(GETCFG(mf128_rom), MF128ROM) == -1)
			{
				Msg(M_INFO, "MF128 emulation disabled");
				SETCFG(mf128_active, False);
			}
		}
#endif
	}
	return ret;
}

int
SelectModel(int model, int reset)
{
#ifdef XZX_PLUS3
	assert(model == 48 || model == 128 || model == 3);
#else
	assert(model == 48 || model == 128);
#endif
	if (GETCFG(machine) != model)
	{
		SETCFG(machine, model);
		SETCFG(cycles, model == 48 ? 69888 : 70908);
		CyclesPerLine = GETCFG(cycles) / TVLINES;
#ifdef SUN_AUDIO
		SpeakerReInit();
#endif
#if defined(XZX_PLUS3) && (defined(XZX_IF1) || defined(XZX_MF128))
		if (model == 3)
		{

#ifdef XZX_IF1
			If1OnOff(False);
#endif
#ifdef XZX_MF128
			SETCFG(mf128_active, False);
#endif
		}
#endif
		if (ReadROMs() == -1)
		{
			return -1;
		}
	}
	if (reset)
	{

		Z80_Reset();
	}
	else
	{
		InitPages();
	}
	return 0;
}

