/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifdef JOY
#ifndef lint
static char rcsid[] = "$Id: joystick.c,v 3.9 1997/11/02 12:14:20 erik Rel $";
#endif

#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#ifdef __FreeBSD__
#include <machine/joystick.h>
#else
#include <linux/joystick.h>
#endif
#include <assert.h>
#include "debug.h"
#include "resource.h"
#include "io.h"
#include "util.h"
#include "dialog.h"
#include "joystick.h"

#ifdef __FreeBSD__
#define JS_RETURN	sizeof(struct joystick)
#endif


int JoyActive = False;

static int jsFd;
static int centreX = 0, centreY = 0;

int
JoyInit(void)
{
#ifndef __FreeBSD__
	struct js_config jsConfig;
#endif
	if ((jsFd = open(GETCFG(joyDevice), O_RDONLY)) < 1)
	{
		Msg(M_PERR, "couldn't open joystick device for reading");
		SETCFG(useJoy, False);
		return -1;
	}
#ifndef __FreeBSD__
	jsConfig.js_timelimit = 10;
	if (ioctl(jsFd, JSIOCSTIMEOUT, &jsConfig.js_timelimit) == -1)
	{
		Msg(M_PERR, "couldn't initialise joystick");
		SETCFG(useJoy, False);
		return -1;
	}
#endif
	JoyActive = True;
	return 0;
}

#ifdef __FreeBSD__
void
JoyCalibrate(void)
{
	int oldInDialog;
	char buffer[COLS + 1];
	struct joystick jsData;
	assert(JoyActive);

	oldInDialog = EnterOSD();
	SetAttr(MENU_TEXT_ATTR);
	ClearScreen();
	SetCursor(2, 1);
	PrintString("Calibrate analogue joystick:");
	SetCursor(0, 4);
	PrintString("Move joystick and fine adjust");
	SetCursor(0, 5);
	PrintString("to min/max values between 0 and");
	SetCursor(0, 6);
	PrintString("2000. Then press a button");
	CheckEvents();
	while (read(jsFd, &jsData, JS_RETURN) > 0 && !(jsData.b1 + jsData.b2))
	{
		(void)sprintf(buffer, "x: %4d, y: %4d", jsData.x, jsData.y );
		SetCursor(7, 8);
		PrintString(buffer);
		ScreenRefresh();
		CheckEvents();
		usleep(500000);
	}
	centreX = jsData.x;
	centreY = jsData.y;
	LeaveOSD(oldInDialog);
}
#else
void
JoyCalibrate(void)
{
#ifndef REGISTERED
	int oldInDialog;
#endif
	struct js_status jsData;
	struct js_config jsConfig;
	int i;
	assert(JoyActive);
#ifdef REGISTERED
	Dialog(DIALOG_INFO,
		   "Move joystick to lower right\nand press either button",
		   "Continue", NULL, DIALOG_OK);
#else

	oldInDialog = EnterOSD();
	SetAttr(MENU_TEXT_ATTR);
	ClearScreen();
	SetCursor(2, 1);
	PrintString("Calibrate analogue joystick:");
	SetCursor(0, 4);
	PrintString("Move joystick to lower right and");
	SetCursor(0, 5);
	PrintString("press either button");
	ScreenRefresh();
#endif
	while ((read(jsFd, &jsData, JS_RETURN) > 0) && !jsData.buttons);
	for (i = 0; jsData.x > 0xff; i++)
	{
		jsData.x >>= 1;
	}
	jsConfig.js_corr.x = i;
	for (i = 0; jsData.y > 0xff; i++)
	{
		jsData.y >>= 1;
	}
	jsConfig.js_corr.y = i;
	if (ioctl(jsFd, JSIOCSCAL, &jsConfig.js_corr) == -1)
	{
		Msg(M_PWARN, "couldn't calibrate joystick");
	}
	else
	{
		while ((read(jsFd, &jsData, JS_RETURN) > 0) && jsData.buttons);
#ifdef REGISTERED
		Dialog(DIALOG_INFO,
			   "Now centeralise the joystick\nand press either button",
			   "Continue", NULL, DIALOG_OK);
#else
		SetCursor(0, 7);
		PrintString("Now centeralise the joystick and");
		SetCursor(0, 8);
        PrintString("press either button");
		ScreenRefresh();
		CheckEvents();
#endif
		while ((read(jsFd, &jsData, JS_RETURN) > 0) && !jsData.buttons);
		centreX = jsData.x;
		centreY = jsData.y;
	}
#ifndef REGISTERED
	LeaveOSD(oldInDialog);
#endif
}
#endif

int
JoyRead(void)
{
#ifdef __FreeBSD__
	struct joystick jsData;
#else
	struct js_status jsData;
#endif
	int res = 0;
	assert(JoyActive);
	if (read(jsFd, &jsData, JS_RETURN) != JS_RETURN)
	{
		Msg(M_PWARN, "lost joystick connection");
	}
	else
	{

		if (jsData.x < centreX - GETCFG(joyTolerance))
		{
			res |= B_LEFT;
		}
		else if (jsData.x > centreX + GETCFG(joyTolerance))
		{
			res |= B_RIGHT;
		}
		if (jsData.y < centreY - GETCFG(joyTolerance))
		{
			res |= B_UP;
		}
		else if (jsData.y > centreY + GETCFG(joyTolerance))
		{
			res |= B_DOWN;
		}
#ifdef __FreeBSD__
		if (jsData.b1 || jsData.b2)
#else
		if (jsData.buttons)
#endif
		{
			res |= B_FIRE;
		}
	}
	return res;
}
#endif

