/********************************************************************************
 * Copyright (c) Erik Kunze 1996
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char nas_c[] = "$Id: nas.c,v 3.3 1997/05/17 15:30:39 erik Rel $";
#endif

#include "z80.h"
#include "debug.h"
#include "util.h"
#include "nas.h"


static void nasQuit(void);


static int nasOn = False;
static int nasActive = False;;
static int nasFd = -1;

int
NasInit(int audioOn)
{
	OnQuit(nasQuit);

	nasActive = True;
	nasOn = True;
	if (!audioOn)
	{
		NasOnOff();
	}
	return 0;
}

static void
nasQuit(void)
{
	if (nasFd != -1)
	{
		(void)close(nasFd);
	}

}

void
NasOnOff(void)
{
	if (nasActive)
	{
		nasOn = !nasOn;

	}
}

